/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class BottomBorder
extends AbstractBorder {
    protected int thickness;
    protected Color lineColor;
    protected int gap;

    public BottomBorder(Color color) {
        this(color, 1, 1);
    }

    public BottomBorder(Color color, int thickness) {
        this(color, thickness, thickness);
    }

    public BottomBorder(Color color, int thickness, int gap) {
        this.lineColor = color;
        this.thickness = thickness;
        this.gap = gap;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            g.drawLine(x, y + height - i - 1, x + width, y + height - i - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, 0, this.gap, 0);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = 0;
        insets.top = 0;
        insets.right = 0;
        insets.bottom = this.gap;
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThickness() {
        return this.thickness;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public int getGap() {
        return this.gap;
    }
}

