/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.SortedList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.search.SearchView;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableModel;
import se.streamsource.streamflow.client.ui.workspace.table.GroupBy;
import se.streamsource.streamflow.client.ui.workspace.table.Period;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectiveOptions;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectivePeriodView;
import se.streamsource.streamflow.client.ui.workspace.table.SortBy;
import se.streamsource.streamflow.client.ui.workspace.table.SortOrder;
import se.streamsource.streamflow.client.util.BottomBorder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.StreamflowToggleButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class PerspectiveView
extends JPanel
implements Observer {
    private static final long serialVersionUID = -149885124005347187L;
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private CasesTableModel model;
    private JDialog popup;
    private JTextField searchField;
    private JPanel optionsPanel;
    private ApplicationContext context;
    private JPanel filterPanel;
    private JPanel viewPanel;
    private JList groupByList;
    private JList sortByList;
    private JList statusList;

    public void initView(@Service ApplicationContext context, @Uses CasesTableModel model, @Optional @Uses JTextField searchField) {
        this.context = context;
        this.model = model;
        model.addObserver(this);
        this.searchField = searchField;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.filterPanel = new JPanel(new FlowLayout(0));
        javax.swing.Action filterClearAction = this.getActionMap().get(FilterActions.filterClear.name());
        StreamflowButton filterClearButton = new StreamflowButton(filterClearAction);
        this.filterPanel.add(filterClearButton);
        this.addPopupButton(this.filterPanel, FilterActions.filterCreatedOn.name());
        List<LinkValue> linkValues = model.possibleFilterLinks();
        if (Iterables.matchesAny((Specification)Links.withRel((String)"possibleprojects"), linkValues)) {
            this.addPopupButton(this.filterPanel, FilterActions.filterProject.name());
        }
        if (Iterables.matchesAny((Specification)Links.withRel((String)"possibleassignees"), linkValues)) {
            this.addPopupButton(this.filterPanel, FilterActions.filterAssignee.name());
        }
        this.addPopupButton(this.filterPanel, FilterActions.filterCaseType.name());
        this.addPopupButton(this.filterPanel, FilterActions.filterLabel.name());
        if (Iterables.matchesAny((Specification)Links.withRel((String)"possiblecreatedby"), linkValues)) {
            this.addPopupButton(this.filterPanel, FilterActions.filterCreatedBy.name());
        }
        this.addPopupButton(this.filterPanel, FilterActions.filterDueOn.name());
        if (Iterables.matchesAny((Specification)Links.withRel((String)"possiblestatus"), linkValues)) {
            this.addPopupButton(this.filterPanel, FilterActions.filterStatus.name());
        }
        this.add((Component)this.filterPanel, "West");
        this.statusList = new StatusList();
        this.viewPanel = new JPanel(new FlowLayout(2));
        this.addPopupButton(this.viewPanel, FilterActions.viewSorting.name());
        this.addPopupButton(this.viewPanel, FilterActions.viewGrouping.name());
        this.add((Component)this.viewPanel, "East");
        this.sortByList = new SortByList();
        this.groupByList = new GroupByList();
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) > 0L && !PerspectiveView.this.isShowing()) {
                    for (Component component : Iterables.flatten((Iterable[])new Iterable[]{Iterables.iterable((Object[])PerspectiveView.this.filterPanel.getComponents()), Iterables.iterable((Object[])PerspectiveView.this.viewPanel.getComponents())})) {
                        if (!(component instanceof StreamflowToggleButton)) continue;
                        ((StreamflowToggleButton)component).setSelected(false);
                    }
                }
            }
        });
    }

    private void addPopupButton(JPanel panel, String action) {
        javax.swing.Action filterAction = this.getActionMap().get(action);
        StreamflowToggleButton button = new StreamflowToggleButton(filterAction);
        button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int state = itemEvent.getStateChange();
                if (state == 1) {
                    for (Component component : Iterables.flatten((Iterable[])new Iterable[]{Iterables.iterable((Object[])PerspectiveView.this.filterPanel.getComponents()), Iterables.iterable((Object[])PerspectiveView.this.viewPanel.getComponents())})) {
                        if (!(component instanceof StreamflowToggleButton) || component == itemEvent.getSource()) continue;
                        ((StreamflowToggleButton)component).setSelected(false);
                    }
                    PerspectiveView.this.optionsPanel = new JPanel();
                    StreamflowToggleButton button = (StreamflowToggleButton)itemEvent.getSource();
                    PerspectiveView.this.showPopup(button);
                } else if (state == 2) {
                    PerspectiveView.this.killPopup();
                }
            }
        });
        panel.add(button);
    }

    @Action
    public void filterClear() {
        this.model.clearFilter();
        if (this.searchField != null) {
            this.searchField.setText("");
        }
        this.killPopup();
    }

    @Action
    public void filterStatus() {
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setPreferredSize(new Dimension(100, 60));
        statusPanel.setMaximumSize(new Dimension(100, 60));
        statusPanel.setMaximumSize(new Dimension(100, 60));
        statusPanel.add((Component)this.statusList, "Center");
        this.optionsPanel.add(statusPanel);
    }

    @Action
    public void filterCaseType() {
        SortedList sortedCaseTypes = new SortedList(this.model.getPossibleCaseTypes(), (Comparator)new SelectedLinkValueComparator(this.model.getSelectedCaseTypes()));
        PerspectiveOptions panel = new PerspectiveOptions(this.context, (List<LinkValue>)sortedCaseTypes, this.model.getSelectedCaseTypeIds(), true, i18n.text(WorkspaceResources.selected_case_types, new Object[0]));
        this.optionsPanel.add(panel);
    }

    @Action
    public void filterLabel() {
        SortedList sortedLabels = new SortedList(this.model.getPossibleLabels(), (Comparator)new SelectedLinkValueComparator(this.model.getSelectedLabels()));
        PerspectiveOptions panel = new PerspectiveOptions(this.context, (List<LinkValue>)sortedLabels, this.model.getSelectedLabelIds(), true, i18n.text(WorkspaceResources.selected_labels, new Object[0]));
        this.optionsPanel.add(panel);
    }

    @Action
    public void filterAssignee() {
        SortedList sortedAssignees = new SortedList(this.model.getPossibleAssignees(), (Comparator)new SelectedLinkValueComparator(this.model.getSelectedAssignees()));
        PerspectiveOptions panel = new PerspectiveOptions(this.context, (List<LinkValue>)sortedAssignees, this.model.getSelectedAssigneeIds(), false, i18n.text(WorkspaceResources.selected_users, new Object[0]));
        this.optionsPanel.add(panel);
    }

    @Action
    public void filterProject() {
        SortedList sortedProjects = new SortedList(this.model.getPossibleProjects(), (Comparator)new SelectedLinkValueComparator(this.model.getSelectedProjects()));
        PerspectiveOptions panel = new PerspectiveOptions(this.context, (List<LinkValue>)sortedProjects, this.model.getSelectedProjectIds(), true, i18n.text(WorkspaceResources.selected_projects, new Object[0]));
        this.optionsPanel.add(panel);
    }

    @Action
    public void filterCreatedOn(ActionEvent event) {
        PerspectivePeriodView period = (PerspectivePeriodView)this.module.objectBuilderFactory().newObjectBuilder(PerspectivePeriodView.class).use(new Object[]{this.model.getCreatedOnModel()}).newInstance();
        this.optionsPanel.add(period);
    }

    @Action
    public void filterDueOn(ActionEvent event) {
        PerspectivePeriodView period = (PerspectivePeriodView)this.module.objectBuilderFactory().newObjectBuilder(PerspectivePeriodView.class).use(new Object[]{this.model.getDueOnModel()}).newInstance();
        this.optionsPanel.add(period);
    }

    @Action
    public void filterCreatedBy() {
        SortedList sortedCreatedBy = new SortedList(this.model.getPossibleCreatedBy(), (Comparator)new SelectedLinkValueComparator(this.model.getSelectedCreatedBy()));
        PerspectiveOptions panel = new PerspectiveOptions(this.context, (List<LinkValue>)sortedCreatedBy, this.model.getSelectedCreatedByIds(), false, i18n.text(WorkspaceResources.selected_users, new Object[0]));
        this.optionsPanel.add(panel);
    }

    @Action
    public void viewSorting() {
        this.optionsPanel.add(this.sortByList);
    }

    @Action
    public void viewGrouping() {
        this.optionsPanel.add(this.groupByList);
    }

    private void showPopup(final Component button) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PerspectiveView.this.popup != null) {
                    PerspectiveView.this.popup.dispose();
                    PerspectiveView.this.popup = null;
                }
                final JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, PerspectiveView.this);
                PerspectiveView.this.popup = new JDialog(frame);
                PerspectiveView.this.popup.getRootPane().registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PerspectiveView.this.killPopup();
                        PerspectiveView.this.cleanToggleButtonSelection();
                    }
                }, KeyStroke.getKeyStroke(10, 0), 2);
                PerspectiveView.this.popup.setUndecorated(true);
                PerspectiveView.this.popup.setModal(false);
                PerspectiveView.this.popup.setLayout(new BorderLayout());
                PerspectiveView.this.popup.add((Component)PerspectiveView.this.optionsPanel, "Center");
                Point location = button.getLocationOnScreen();
                PerspectiveView.this.popup.setBounds((int)location.getX(), (int)location.getY() + button.getHeight(), PerspectiveView.this.optionsPanel.getWidth(), PerspectiveView.this.optionsPanel.getHeight());
                PerspectiveView.this.popup.pack();
                PerspectiveView.this.popup.setVisible(true);
                frame.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        if (PerspectiveView.this.popup != null) {
                            PerspectiveView.this.killPopup();
                            frame.removeComponentListener(this);
                        }
                    }
                });
            }
        });
    }

    public void killPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
        if (!this.windowContainsSearchView(WindowUtils.findWindow((Component)this))) {
            this.model.refresh();
        } else {
            this.update(null, null);
        }
    }

    private boolean windowContainsSearchView(Container container) {
        boolean result = false;
        for (Component c : container.getComponents()) {
            if (!(c instanceof Container)) continue;
            if (c instanceof SearchView) {
                result = c.isShowing();
                continue;
            }
            result |= this.windowContainsSearchView((Container)c);
        }
        return result;
    }

    public JDialog getCurrentPopup() {
        return this.popup;
    }

    public void setCurrentPopup(JDialog dialog) {
        this.popup = dialog;
    }

    public void cleanToggleButtonSelection() {
        for (Component component : Iterables.flatten((Iterable[])new Iterable[]{Iterables.iterable((Object[])this.filterPanel.getComponents()), Iterables.iterable((Object[])this.viewPanel.getComponents())})) {
            if (!(component instanceof StreamflowToggleButton) || !((StreamflowToggleButton)component).isSelected()) continue;
            ((StreamflowToggleButton)component).setSelected(false);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        for (Component comp : Iterables.flatten((Iterable[])new Iterable[]{Iterables.iterable((Object[])this.filterPanel.getComponents()), Iterables.iterable((Object[])this.viewPanel.getComponents())})) {
            if (!(comp instanceof StreamflowToggleButton)) continue;
            StreamflowToggleButton button = (StreamflowToggleButton)comp;
            boolean selectedIsEmpty = true;
            switch (FilterActions.valueOf(((ApplicationAction)button.getAction()).getName())) {
                case filterStatus: {
                    selectedIsEmpty = this.model.getSelectedStatuses().isEmpty();
                    break;
                }
                case filterAssignee: {
                    selectedIsEmpty = this.model.getSelectedAssigneeIds().isEmpty();
                    break;
                }
                case filterLabel: {
                    selectedIsEmpty = this.model.getSelectedLabelIds().isEmpty();
                    break;
                }
                case filterProject: {
                    selectedIsEmpty = this.model.getSelectedProjectIds().isEmpty();
                    break;
                }
                case filterCaseType: {
                    selectedIsEmpty = this.model.getSelectedCaseTypeIds().isEmpty();
                    break;
                }
                case filterCreatedBy: {
                    selectedIsEmpty = this.model.getSelectedCreatedByIds().isEmpty();
                    break;
                }
                case filterCreatedOn: {
                    selectedIsEmpty = Period.none.equals((Object)this.model.getCreatedOnModel().getPeriod());
                    break;
                }
                case filterDueOn: {
                    selectedIsEmpty = Period.none.equals((Object)this.model.getDueOnModel().getPeriod());
                    break;
                }
                case viewSorting: {
                    selectedIsEmpty = SortBy.none.equals((Object)this.model.getSortBy());
                    break;
                }
                case viewGrouping: {
                    selectedIsEmpty = GroupBy.none.equals((Object)this.model.getGroupBy());
                    break;
                }
            }
            button.setIcon(selectedIsEmpty ? i18n.icon(Icons.down_no_selection, 16) : i18n.icon(Icons.down_with_selection, 16));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PerspectiveView.this.invalidate();
            }
        });
    }

    class GroupByList
    extends JList {
        public GroupByList() {
            super(GroupBy.values());
            this.setSelectedIndex(0);
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setFont(list.getFont());
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                    if (value.equals((Object)PerspectiveView.this.model.getGroupBy())) {
                        this.setIcon(i18n.icon(Icons.check, 12));
                        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                    } else {
                        this.setIcon(null);
                        this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                    }
                    this.setText(i18n.text((GroupBy)((Object)value), new Object[0]));
                    return this;
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        PerspectiveView.this.model.setGroupBy((GroupBy)((Object)GroupByList.this.getSelectedValue()));
                    }
                }
            });
        }
    }

    class SortByList
    extends JList {
        public SortByList() {
            ArrayList<Enum> allValues = new ArrayList<Enum>();
            allValues.addAll(Arrays.asList(SortBy.values()));
            allValues.addAll(Arrays.asList(SortOrder.values()));
            this.setListData(allValues.toArray());
            this.setSelectedIndex(0);
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setFont(list.getFont());
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                    if (value.equals((Object)PerspectiveView.this.model.getSortBy()) || value.equals((Object)PerspectiveView.this.model.getSortOrder())) {
                        this.setIcon(i18n.icon(Icons.check, 12));
                        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                    } else {
                        this.setIcon(null);
                        this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                    }
                    this.setText(i18n.text((Enum)value, new Object[0]));
                    if (index == SortBy.values().length - 1) {
                        this.setBorder(BorderFactory.createCompoundBorder(new BottomBorder(Color.LIGHT_GRAY, 1, 3), this.getBorder()));
                    }
                    return this;
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    Enum selectedValue;
                    if (!event.getValueIsAdjusting() && (selectedValue = (Enum)SortByList.this.getSelectedValue()) != null) {
                        if (selectedValue instanceof SortBy) {
                            PerspectiveView.this.model.setSortBy((SortBy)selectedValue);
                        } else {
                            PerspectiveView.this.model.setSortOrder((SortOrder)selectedValue);
                        }
                        SortByList.this.clearSelection();
                        SortByList.this.repaint();
                    }
                }
            });
        }
    }

    class StatusList
    extends JList {
        public StatusList() {
            super(new Object[]{WorkspaceResources.OPEN.name(), WorkspaceResources.ON_HOLD.name(), WorkspaceResources.CLOSED.name()});
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    this.setFont(list.getFont());
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                    if (PerspectiveView.this.model.getSelectedStatuses().contains(value)) {
                        this.setIcon(i18n.icon(Icons.check, 12));
                        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                    } else {
                        this.setIcon(null);
                        this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                    }
                    this.setText(i18n.text(WorkspaceResources.valueOf(value.toString()), new Object[0]));
                    return this;
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    String selectedValue;
                    if (!event.getValueIsAdjusting() && (selectedValue = (String)PerspectiveView.this.statusList.getSelectedValue()) != null) {
                        if (PerspectiveView.this.model.getSelectedStatuses().contains(selectedValue)) {
                            PerspectiveView.this.model.getSelectedStatuses().remove(selectedValue);
                        } else {
                            PerspectiveView.this.model.getSelectedStatuses().add(selectedValue);
                        }
                        PerspectiveView.this.statusList.clearSelection();
                    }
                }
            });
        }
    }

    class SelectedLinkValueComparator
    implements Comparator<LinkValue> {
        private List<String> selected;

        public SelectedLinkValueComparator(List<String> selectedValues) {
            this.selected = selectedValues;
        }

        @Override
        public int compare(LinkValue o1, LinkValue o2) {
            int val1 = this.selected.contains(o1.text().get()) ? 1 : 0;
            int val2 = this.selected.contains(o2.text().get()) ? 1 : 0;
            int selectedCompare = val2 - val1;
            if (selectedCompare == 0) {
                return ((String)o1.text().get()).compareToIgnoreCase((String)o2.text().get());
            }
            return selectedCompare;
        }
    }

    private static enum FilterActions {
        filterClear,
        filterStatus,
        filterCaseType,
        filterLabel,
        filterAssignee,
        filterProject,
        filterCreatedBy,
        filterCreatedOn,
        filterDueOn,
        viewSorting,
        viewGrouping;

    }
}

