/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.util.BottomBorder;
import se.streamsource.streamflow.client.util.FilteredList;
import se.streamsource.streamflow.client.util.GroupedFilteredList;
import se.streamsource.streamflow.client.util.i18n;

public class PerspectiveOptions
extends JPanel {
    private JList itemList;
    private JTextField filterField;

    public PerspectiveOptions(ApplicationContext context, List<LinkValue> values, final List selectedValues, final boolean isGrouped, String selectionTitle) {
        super(new BorderLayout());
        JPanel list;
        final int currentSelectedLabelCount = selectedValues.size();
        this.setPreferredSize(new Dimension(250, 200));
        this.setMaximumSize(new Dimension(250, 200));
        this.setMinimumSize(new Dimension(250, 200));
        if (isGrouped) {
            list = new GroupedFilteredList();
            ((GroupedFilteredList)list).getList().setSelectionMode(0);
            BasicEventList titledLinks = new BasicEventList();
            int count = 0;
            for (LinkValue link : values) {
                TitledLinkValue linkValue = (TitledLinkValue)link;
                if (count < selectedValues.size()) {
                    ValueBuilder builder = linkValue.buildWith();
                    ((TitledLinkValue)builder.prototype()).title().set((Object)selectionTitle);
                    titledLinks.add(builder.newInstance());
                } else {
                    titledLinks.add((Object)linkValue);
                }
                ++count;
            }
            ((GroupedFilteredList)list).setEventList((EventList<TitledLinkValue>)titledLinks, selectionTitle, false);
            this.itemList = ((GroupedFilteredList)list).getList();
            this.filterField = ((GroupedFilteredList)list).getFilterField();
        } else {
            list = new FilteredList();
            ((FilteredList)list).getList().setSelectionMode(0);
            ((FilteredList)list).setEventList((EventList<LinkValue>)((EventList)values), false);
            this.itemList = ((FilteredList)list).getList();
            this.filterField = ((FilteredList)list).getFilterField();
        }
        this.add(list);
        this.itemList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof SeparatorList.Separator) {
                    SeparatorList.Separator separator = (SeparatorList.Separator)value;
                    String text = separator.first() instanceof TitledLinkValue ? (String)((TitledLinkValue)separator.first()).title().get() : (String)((LinkValue)separator.first()).text().get();
                    Component component = super.getListCellRendererComponent((JList<?>)list, text, index, isSelected, cellHasFocus);
                    this.setFont(this.getFont().deriveFont(1));
                    return component;
                }
                LinkValue linkValue = (LinkValue)value;
                this.setFont(list.getFont());
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                if (selectedValues.contains(linkValue.id().get())) {
                    this.setIcon(i18n.icon(Icons.check, 12));
                    this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                } else {
                    this.setIcon(null);
                    this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                }
                this.setText((String)linkValue.text().get());
                if (isGrouped ? index == currentSelectedLabelCount : index == currentSelectedLabelCount - 1) {
                    this.setBorder(BorderFactory.createCompoundBorder(new BottomBorder(Color.LIGHT_GRAY, 1, 3), this.getBorder()));
                }
                return this;
            }
        });
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                LinkValue linkValue;
                if (!event.getValueIsAdjusting() && !(PerspectiveOptions.this.itemList.getSelectedValue() instanceof SeparatorList.Separator) && (linkValue = (LinkValue)PerspectiveOptions.this.itemList.getSelectedValue()) != null) {
                    if (selectedValues.contains(linkValue.id().get())) {
                        selectedValues.remove(linkValue.id().get());
                    } else {
                        selectedValues.add(linkValue.id().get());
                    }
                    PerspectiveOptions.this.itemList.clearSelection();
                }
            }
        });
        if (values.size() < 10) {
            this.filterField.setVisible(false);
        }
    }

    public void setSelectionMode(int selectionMode) {
        this.itemList.setSelectionMode(selectionMode);
    }

    public JTextField getFilterField() {
        return this.filterField;
    }
}

