/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.search;

import ca.odell.glazedlists.TransactionList;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.dci.value.table.TableQuery;
import se.streamsource.dci.value.table.TableValue;
import se.streamsource.streamflow.client.ui.workspace.search.SearchTerms;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableModel;

public class SearchResultTableModel
extends CasesTableModel {
    private String searchString;

    public SearchResultTableModel(@Structure Module module) {
        super(module);
    }

    @Override
    public void search(String text) {
        this.searchString = text;
        this.refresh();
    }

    @Override
    public void refresh() {
        if (this.searchString != null) {
            TableValue result = this.performSearch();
            this.eventList.getReadWriteLock().writeLock().lock();
            try {
                if (this.eventList instanceof TransactionList) {
                    ((TransactionList)this.eventList).beginEvent();
                }
                this.eventList.clear();
                this.eventList.addAll(this.caseTableValues(result));
                if (this.eventList instanceof TransactionList) {
                    ((TransactionList)this.eventList).commitEvent();
                }
            }
            finally {
                this.eventList.getReadWriteLock().writeLock().unlock();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    private TableValue performSearch() {
        String translatedQuery = SearchTerms.translate(this.searchString);
        translatedQuery = translatedQuery + this.addWhereClauseFromFilter();
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(TableQuery.class);
        String query = "select * where " + translatedQuery;
        query = query + this.addSortingFromFilter();
        query = query + " limit 1000";
        ((TableQuery)builder.prototype()).tq().set((Object)query);
        return (TableValue)this.client.query("cases", TableValue.class, builder.newInstance());
    }

    public void clearSearchString() {
        this.searchString = "";
    }
}

