/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.note;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXPanel;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.object.ObjectBuilderFactory;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.api.workspace.cases.general.NoteDTO;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.note.CaseNoteModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowToggleButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Translator;

public class CaseNoteView
extends JPanel
implements TransactionListener,
Refreshable {
    private ValueBinder valueBinder;
    private ActionBinder actionBinder;
    private CaseNoteModel model;
    private JTextPane note;
    private JDialog popup;
    StreamflowToggleButton allNotesBtn;

    public CaseNoteView(@Service ApplicationContext appContext, @Uses CaseNoteModel model, @Structure Module module) {
        this.model = model;
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        ActionMap am = this.getActionMap();
        ObjectBuilderFactory obf = module.objectBuilderFactory();
        FormLayout formLayout = new FormLayout("70dlu, 3dlu, pref, 3dlu, right:70dlu:grow", "pref,120:grow");
        this.setLayout((LayoutManager)formLayout);
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, (JPanel)this);
        this.valueBinder = (ValueBinder)obf.newObject(ValueBinder.class);
        this.actionBinder = (ActionBinder)obf.newObjectBuilder(ActionBinder.class).use(new Object[]{am}).newInstance();
        this.actionBinder.setResourceMap(appContext.getResourceMap(this.getClass()));
        formBuilder.append(i18n.text(WorkspaceResources.note_label, new Object[0]));
        this.allNotesBtn = new StreamflowToggleButton(am.get("allNotes"));
        this.allNotesBtn.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int state = itemEvent.getStateChange();
                if (state == 1) {
                    CaseNoteView.this.showPopup(CaseNoteView.this.allNotesBtn);
                } else if (state == 2) {
                    CaseNoteView.this.killPopup();
                }
            }
        });
        formBuilder.nextColumn(2);
        formBuilder.append((Component)this.allNotesBtn);
        JScrollPane textScroll = null;
        this.note = new JTextPane();
        textScroll = new JScrollPane(this.valueBinder.bind("note", this.actionBinder.bind("addNote", this.note)));
        formBuilder.add((Component)textScroll, new CellConstraints(1, 2, 5, 1, CellConstraints.FILL, CellConstraints.FILL));
        textScroll.setPreferredSize(new Dimension(210, 120));
        textScroll.getViewport().getView().setFocusTraversalKeys(0, null);
        textScroll.getViewport().getView().setFocusTraversalKeys(1, null);
        RefreshComponents refreshComponents = new RefreshComponents();
        model.addObserver(refreshComponents);
        refreshComponents.enabledOn("addnote", this.note);
        new RefreshWhenShowing(this, this);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task addNote(final ActionEvent event) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseNoteView.this.model.addNote(((JTextPane)event.getSource()).getText());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public void allNotes(ActionEvent event) {
    }

    @Override
    public void refresh() {
        this.model.refresh();
        if (Translator.HTML.equalsIgnoreCase((String)this.model.getNote().contentType().get())) {
            this.note.setContentType(Translator.HTML);
            this.note.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.note.setEditable(true);
        } else {
            this.note.setContentType(Translator.PLAIN);
            this.note.setEditable(true);
        }
        this.valueBinder.update((ValueComposite)this.model.getNote());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedNote", "changedStatus"}), transactions)) {
            this.refresh();
        }
    }

    private void showPopup(JComponent component) {
        JXPanel panel = new JXPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JScrollPane scroll = new JScrollPane();
        panel.add((Component)scroll);
        JList<Object> notes = new JList<Object>();
        scroll.setViewportView(notes);
        notes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    NoteDTO selectedNote = (NoteDTO)((JList)e.getSource()).getSelectedValue();
                    if (!((Date)selectedNote.createdOn().get()).equals(CaseNoteView.this.model.getNote().createdOn().get())) {
                        CaseNoteView.this.note.setEnabled(false);
                    } else {
                        CaseNoteView.this.note.setEnabled(CaseNoteView.this.model.checkNoteEnabled());
                    }
                    CaseNoteView.this.note.setText((String)selectedNote.note().get());
                    CaseNoteView.this.model.setSelectedNoteIndex(e.getLastIndex());
                }
            }
        });
        notes.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!(e.getOppositeComponent() instanceof StreamflowToggleButton)) {
                    CaseNoteView.this.allNotesBtn.doClick();
                } else if (e.getOppositeComponent() instanceof StreamflowToggleButton) {
                    CaseNoteView.this.killPopup();
                }
            }
        });
        notes.setModel((ListModel<Object>)this.model.getNotes());
        notes.setSelectedIndex(this.model.getSelectedNoteIndex());
        notes.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                NoteDTO note = (NoteDTO)value;
                JPanel itemPanel = new JPanel();
                itemPanel.setLayout(new BoxLayout(itemPanel, 0));
                JLabel date = new JLabel(DateFormats.getProgressiveDateTimeValue((Date)note.createdOn().get(), Locale.getDefault()) + "   ", 2);
                JLabel name = new JLabel((String)note.creator().get(), 4);
                itemPanel.add((Component)date, Float.valueOf(0.0f));
                itemPanel.add(Box.createHorizontalGlue());
                itemPanel.add((Component)name, Float.valueOf(1.0f));
                itemPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
                if (isSelected) {
                    itemPanel.setBackground(list.getSelectionBackground());
                    date.setForeground(list.getSelectionForeground());
                    name.setForeground(list.getSelectionForeground());
                } else {
                    itemPanel.setBackground(list.getBackground());
                    date.setForeground(list.getForeground());
                    name.setForeground(list.getForeground());
                }
                return itemPanel;
            }
        });
        final JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        this.popup = new JDialog(frame);
        this.popup.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaseNoteView.this.killPopup();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.popup.setUndecorated(true);
        this.popup.setModal(false);
        this.popup.setLayout(new BorderLayout());
        this.popup.add((Component)panel, "Center");
        Point location = component.getLocationOnScreen();
        int diff = (int)panel.getPreferredSize().getWidth() - component.getWidth();
        this.popup.setBounds((int)location.getX() - diff, (int)location.getY() + component.getHeight(), (int)panel.getPreferredSize().getWidth(), (int)panel.getPreferredSize().getHeight());
        this.popup.pack();
        this.popup.setVisible(true);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (CaseNoteView.this.popup != null) {
                    CaseNoteView.this.killPopup();
                    frame.removeComponentListener(this);
                }
            }
        });
    }

    private void killPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
    }
}

