/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.note;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import java.util.Collection;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.general.NoteDTO;
import se.streamsource.streamflow.client.util.Refreshable;

public class CaseNoteModel
extends Observable
implements Refreshable {
    @Structure
    Module module;
    private CommandQueryClient client;
    private int selectedNoteIndex = 0;
    private NoteDTO note;
    private ResourceValue resource;

    public CaseNoteModel(@Uses CommandQueryClient client) {
        this.client = client;
    }

    @Override
    public void refresh() {
        this.resource = this.client.query();
        this.note = (NoteDTO)((ValueComposite)this.resource.index().get()).buildWith().prototype();
        this.setChanged();
        this.notifyObservers(this.resource);
    }

    public void addNote(String newNote) {
        if (newNote.equals(this.note.note().get())) {
            return;
        }
        this.note.note().set((Object)newNote);
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(NoteDTO.class).withPrototype((Object)this.note);
        ((NoteDTO)builder.prototype()).contentType().set(this.note.contentType().get());
        this.client.postCommand("addnote", builder.newInstance());
    }

    public NoteDTO getNote() {
        return this.note;
    }

    public EventListModel<LinkValue> getNotes() {
        BasicEventList notes = new BasicEventList();
        notes.addAll((Collection)((LinksValue)this.client.query("allnotes", LinksValue.class)).links().get());
        return new EventListModel((EventList)notes);
    }

    public boolean checkNoteEnabled() {
        return Iterables.matchesAny((Specification)Links.withRel((String)"addnote"), (Iterable)((Iterable)this.resource.commands().get()));
    }

    public void setSelectedNoteIndex(int index) {
        this.selectedNoteIndex = index;
    }

    public int getSelectedNoteIndex() {
        return this.selectedNoteIndex;
    }
}

