/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.Collections;
import java.util.List;
import javax.swing.event.MouseInputListener;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.input.PanKeyListener;
import org.jxmapviewer.input.PanMouseInputListener;
import org.jxmapviewer.input.ZoomMouseWheelListenerCursor;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.DefaultWaypoint;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.WaypointPainter;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.AreaPainter;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoLocationFieldPanelResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarkerHolder;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LineMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LinePainter;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.MapInteractionMode;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PointMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PolygonMarker;
import se.streamsource.streamflow.client.util.i18n;

public class PanZoomInteractionMode
implements MapInteractionMode {
    private MouseInputListener panMouseInputListener;
    private ZoomMouseWheelListenerCursor zoomMouseWheelListener;
    private PanKeyListener panKeyListener;

    @Override
    public void enterMode(JXMapViewer mapViewer, GeoMarkerHolder geoMarkerHolder) {
        this.panMouseInputListener = new PanMouseInputListener(mapViewer);
        mapViewer.addMouseListener((MouseListener)this.panMouseInputListener);
        mapViewer.addMouseMotionListener((MouseMotionListener)this.panMouseInputListener);
        this.zoomMouseWheelListener = new ZoomMouseWheelListenerCursor(mapViewer);
        mapViewer.addMouseWheelListener((MouseWheelListener)this.zoomMouseWheelListener);
        this.panKeyListener = new PanKeyListener(mapViewer);
        mapViewer.addKeyListener((KeyListener)this.panKeyListener);
        mapViewer.setOverlayPainter(this.painterForMarker(geoMarkerHolder.getCurrentGeoMarker()));
    }

    private Painter<JXMapViewer> painterForMarker(GeoMarker marker) {
        if (marker instanceof PointMarker) {
            PointMarker point = (PointMarker)marker;
            WaypointPainter waypointPainter = new WaypointPainter();
            waypointPainter.setWaypoints(Collections.singleton(new DefaultWaypoint(point.getPosition())));
            return waypointPainter;
        }
        if (marker instanceof LineMarker) {
            List<GeoPosition> points = marker.getPoints();
            LinePainter linePainter = new LinePainter();
            linePainter.setPoints(points);
            return linePainter;
        }
        if (marker instanceof PolygonMarker) {
            List<GeoPosition> points = marker.getPoints();
            AreaPainter areaPainter = new AreaPainter();
            areaPainter.setPoints(points);
            return areaPainter;
        }
        return null;
    }

    @Override
    public void leaveMode(JXMapViewer mapViewer) {
        mapViewer.removeMouseListener((MouseListener)this.panMouseInputListener);
        mapViewer.removeMouseMotionListener((MouseMotionListener)this.panMouseInputListener);
        mapViewer.removeMouseWheelListener((MouseWheelListener)this.zoomMouseWheelListener);
        mapViewer.removeKeyListener((KeyListener)this.panKeyListener);
        mapViewer.setOverlayPainter(null);
    }

    @Override
    public String getHelpHint() {
        return i18n.text(GeoLocationFieldPanelResources.mode_hint_pan_zoom, new Object[0]);
    }
}

