/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.Painter;
import org.jxmapviewer.viewer.GeoPosition;

public class LinePainter
implements Painter<JXMapViewer> {
    private Color color = Color.RED;
    private Color outlineColor = Color.BLACK;
    private List<GeoPosition> points = new ArrayList<GeoPosition>();

    void setPoints(Collection<GeoPosition> points) {
        this.points = new ArrayList<GeoPosition>(points);
    }

    public void paint(Graphics2D g, JXMapViewer map, int w, int h) {
        g = (Graphics2D)g.create();
        Rectangle rect = map.getViewportBounds();
        g.translate(-rect.x, -rect.y);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(this.outlineColor);
        g.setStroke(new BasicStroke(4.0f));
        this.drawLines(g, map);
        g.setColor(this.color);
        g.setStroke(new BasicStroke(2.0f));
        this.drawLines(g, map);
        g.dispose();
    }

    private void drawLines(Graphics2D g, JXMapViewer map) {
        int lastX = 0;
        int lastY = 0;
        boolean first = true;
        for (GeoPosition gp : this.points) {
            Point2D pt = map.getTileFactory().geoToPixel(gp, map.getZoom());
            if (first) {
                first = false;
            } else {
                g.drawLine(lastX, lastY, (int)pt.getX(), (int)pt.getY());
            }
            lastX = (int)pt.getX();
            lastY = (int)pt.getY();
        }
    }
}

