/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.ListBoxFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.util.MultiFieldHelper;

public class ListBoxPanel
extends AbstractFieldPanel {
    private StreamflowButton left;
    private StreamflowButton right;
    private JList selectedElements;
    private JList possibleElements;

    public ListBoxPanel(@Uses FieldSubmissionDTO field, @Uses ListBoxFieldValue fieldValue, @Service ApplicationContext context) {
        super(field);
        FormLayout formLayout = new FormLayout("80dlu, 40dlu, 80dlu", "20dlu, 20dlu, 20dlu, 20dlu");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, (JPanel)this);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (String element : (List)fieldValue.values().get()) {
            listModel.addElement(element);
        }
        this.possibleElements = new JList(listModel);
        this.selectedElements = new JList(new DefaultListModel());
        ApplicationActionMap map = context.getActionMap((Object)this);
        this.right = new StreamflowButton(map.get((Object)"left"));
        this.left = new StreamflowButton(map.get((Object)"right"));
        this.possibleElements.setSelectionMode(2);
        this.possibleElements.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(map.get((Object)"left")));
        this.selectedElements.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(map.get((Object)"right")));
        formBuilder.add((Component)new JScrollPane(this.possibleElements), "1,1,1,4");
        formBuilder.add((Component)this.right, "2,2");
        formBuilder.add((Component)this.left, "2,3");
        formBuilder.add((Component)new JScrollPane(this.selectedElements), "3,1,1,4");
    }

    @Action
    public void left() {
        Object[] selectedValues;
        DefaultListModel model = (DefaultListModel)this.selectedElements.getModel();
        DefaultListModel possibleModel = (DefaultListModel)this.possibleElements.getModel();
        for (Object value : selectedValues = this.possibleElements.getSelectedValues()) {
            model.addElement(value);
            possibleModel.removeElement(value);
        }
        this.binding.updateProperty(this.getValue());
    }

    @Action
    public void right() {
        Object[] objects;
        DefaultListModel model = (DefaultListModel)this.selectedElements.getModel();
        DefaultListModel possibleModel = (DefaultListModel)this.possibleElements.getModel();
        for (Object value : objects = this.selectedElements.getSelectedValues()) {
            possibleModel.addElement(value);
            model.removeElement(value);
        }
        this.binding.updateProperty(this.getValue());
    }

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        ListModel model = this.selectedElements.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String elm;
            if (!first) {
                sb.append(", ");
            }
            if ((elm = (String)model.getElementAt(i)).contains(",")) {
                sb.append("[").append(elm).append("]");
            } else {
                sb.append(elm);
            }
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void setValue(String newValue) {
        if (newValue == null || newValue.equals("")) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.selectedElements.getModel();
        DefaultListModel possibleModel = (DefaultListModel)this.possibleElements.getModel();
        for (String element : MultiFieldHelper.options((String)newValue)) {
            model.addElement(element);
            possibleModel.removeElement(element);
        }
    }

    @Override
    public void setBinding(StateBinder.Binding binding) {
        this.binding = binding;
    }
}

