/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.util.LinkedLabel;
import se.streamsource.streamflow.client.util.i18n;

public class RemovableLabel
extends JPanel
implements FocusListener {
    private JButton button;
    private LinkValue removeLink;
    private LinkValue clickLink;
    private LinkedLabel label;

    public RemovableLabel() {
        this.initComponents();
    }

    public RemovableLabel(LinkValue removeLink, LinkValue clickLink) {
        this.removeLink = removeLink;
        this.clickLink = clickLink;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(2, 1));
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        if (this.removeLink != null) {
            this.label = new LinkedLabel();
            this.label.setLink(this.clickLink, (String)this.removeLink.text().get());
        } else {
            this.label = new LinkedLabel();
        }
        this.button = new JButton(i18n.icon(Icons.drop, 12));
        this.button.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.button.setBorderPainted(false);
        this.button.setContentAreaFilled(false);
        this.button.setFocusable(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemovableLabel.this.requestFocus();
            }
        });
        this.add((Component)this.label, "Center");
        this.add((Component)this.button, "East");
        this.addFocusListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\b' || e.getKeyChar() == '\u007f') {
                    RemovableLabel.this.button.doClick();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RemovableLabel.this.requestFocusInWindow();
            }
        });
        this.setVisible(this.removeLink != null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.button.setVisible(enabled);
        this.label.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public LinkValue getRemoveLink() {
        return this.removeLink;
    }

    public JButton getButton() {
        return this.button;
    }

    public LinkedLabel getLabel() {
        return this.label;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.repaint();
    }

    public void setText(String text) {
        this.label.setText(text);
        this.setToolTipText(text);
        this.setVisible(text != null);
    }

    public void setRemoveLink(LinkValue link) {
        this.removeLink = link;
        if (link != null) {
            this.label.setLink(this.clickLink, (String)this.removeLink.text().get());
        }
        this.setVisible(link != null);
    }

    public void setClickLink(LinkValue link) {
        this.clickLink = link;
        if (link != null) {
            this.label.setLink(this.clickLink, (String)this.removeLink.text().get());
        }
    }

    public void setLinks(LinkValue removeLink, LinkValue clickLink) {
        this.clickLink = clickLink;
        this.setRemoveLink(removeLink);
    }
}

