/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.forms;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.util.Iterables;
import se.streamsource.streamflow.api.workspace.cases.form.SubmittedFormListDTO;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.forms.CaseSubmittedFormsModel;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CaseSubmittedFormsView
extends JPanel
implements TransactionListener,
Refreshable {
    private CaseSubmittedFormsModel model;
    private JTree submittedForms;
    private JScrollPane scroll;

    public CaseSubmittedFormsView(@Service ApplicationContext context, final @Uses CaseSubmittedFormsModel model) {
        super(new BorderLayout());
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.setMinimumSize(new Dimension(150, 0));
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.scroll = new JScrollPane();
        this.submittedForms = new JTree(new DefaultMutableTreeNode("Root"));
        this.submittedForms.setRootVisible(false);
        this.submittedForms.getSelectionModel().setSelectionMode(1);
        this.submittedForms.setShowsRootHandles(true);
        this.scroll.setViewportView(this.submittedForms);
        this.submittedForms.setCellRenderer((TreeCellRenderer)new DefaultTreeRenderer(){

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (((DefaultMutableTreeNode)value).getUserObject() instanceof SubmittedFormListDTO) {
                    final SubmittedFormListDTO listDTO = (SubmittedFormListDTO)((DefaultMutableTreeNode)value).getUserObject();
                    ArrayList modelSubmittedForms = (ArrayList)Iterables.addAll(new ArrayList(), model.getSubmittedForms());
                    Collections.reverse(modelSubmittedForms);
                    SubmittedFormListDTO lastSubmitted = (SubmittedFormListDTO)Iterables.first((Iterable)Iterables.filter((Specification)new Specification<SubmittedFormListDTO>(){

                        public boolean satisfiedBy(SubmittedFormListDTO item) {
                            return ((String)listDTO.form().get()).equals(item.form().get());
                        }
                    }, (Iterable)modelSubmittedForms));
                    if (listDTO == lastSubmitted) {
                        Component c = super.getTreeCellRendererComponent(tree, listDTO.form().get(), sel, expanded, leaf, row, hasFocus);
                        Map<TextAttribute, ?> attributes = c.getFont().getAttributes();
                        if (((Boolean)listDTO.unread().get()).booleanValue()) {
                            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                        }
                        c.setFont(new Font(attributes));
                        return c;
                    }
                    String dateString = new SimpleDateFormat(i18n.text(WorkspaceResources.date_time_format, new Object[0])).format((Date)listDTO.submissionDate().get());
                    return super.getTreeCellRendererComponent(tree, (Object)dateString, sel, expanded, leaf, row, hasFocus);
                }
                return super.getTreeCellRendererComponent(tree, (Object)"DummyNode", sel, expanded, leaf, row, hasFocus);
            }
        });
        JScrollPane submittedFormsScollPane = new JScrollPane();
        submittedFormsScollPane.setViewportView(this.submittedForms);
        this.add((Component)submittedFormsScollPane, "Center");
        new RefreshWhenShowing(this, this);
    }

    public JTree getSubmittedFormsTree() {
        return this.submittedForms;
    }

    public CaseSubmittedFormsModel getModel() {
        return this.model;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"submittedForm", "setUnread"}), transactions)) {
            TreePath path = this.submittedForms.getSelectionPath();
            this.refresh();
            if (path != null) {
                String form = (String)((SubmittedFormListDTO)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()).form().get();
                Enumeration<TreeNode> e = ((DefaultMutableTreeNode)this.submittedForms.getModel().getRoot()).children();
                TreePath newPath = null;
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                    if (!((String)((SubmittedFormListDTO)node.getUserObject()).form().get()).equalsIgnoreCase(form)) continue;
                    newPath = new TreePath(node.getPath());
                    break;
                }
                if (newPath != null) {
                    this.submittedForms.setSelectionPath(newPath);
                }
            }
        }
    }

    @Override
    public void refresh() {
        this.model.refresh();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root", true);
        HashSet<Object> formNames = new HashSet<Object>();
        for (SubmittedFormListDTO submittedForm : this.model.getSubmittedForms()) {
            formNames.add(submittedForm.form().get());
        }
        ArrayList modelSubmittedForms = (ArrayList)Iterables.addAll(new ArrayList(), this.model.getSubmittedForms());
        Collections.reverse(modelSubmittedForms);
        for (final String name : formNames) {
            ArrayList filtered = (ArrayList)Iterables.addAll(new ArrayList(), (Iterable)Iterables.filter((Specification)new Specification<SubmittedFormListDTO>(){

                public boolean satisfiedBy(SubmittedFormListDTO item) {
                    return name.equals(item.form().get());
                }
            }, (Iterable)modelSubmittedForms));
            DefaultMutableTreeNode firstLevel = null;
            boolean first = true;
            for (SubmittedFormListDTO form : filtered) {
                if (first) {
                    firstLevel = new DefaultMutableTreeNode(form, true);
                    root.add(firstLevel);
                    first = false;
                    continue;
                }
                DefaultMutableTreeNode secondLevel = new DefaultMutableTreeNode(form);
                firstLevel.add(secondLevel);
            }
        }
        this.submittedForms.setModel(new DefaultTreeModel(root));
    }
}

