/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Date;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXLabel;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.api.workspace.cases.conversation.MessageType;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageAttachmentsView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.WrapLayout;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class MessageView
extends JPanel
implements Refreshable,
TransactionListener {
    @Structure
    Module module;
    private JTextPane showMessage;
    private JXLabel authorLabelValue;
    private JXLabel createdOnLabelValue;
    private MessageAttachmentsView attachmentsView;
    private ValueBinder valueBinder;
    private MessageModel model;

    public MessageView(@Service ApplicationContext context, @Structure Module module, @Uses MessageModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.setPreferredSize(new Dimension(100, 250));
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JScrollPane messageShowScroll = new JScrollPane();
        this.valueBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        JPanel messageDetailButtonPanel = new JPanel(new BorderLayout());
        messageDetailButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        Action closeAction = context.getActionMap().get((Object)"closeMessageDetails");
        StreamflowButton closeButton = new StreamflowButton(closeAction);
        JPanel closeButtonPanel = new JPanel(new FlowLayout(0, 0, 0));
        closeButtonPanel.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        closeButtonPanel.add(closeButton);
        FormLayout detailLabelLayout = new FormLayout("35dlu, 2dlu, pref:grow", "pref, pref");
        JPanel messageDetailsLabelPanel = new JPanel();
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(detailLabelLayout, messageDetailsLabelPanel);
        JXLabel authorLabel = new JXLabel(i18n.text(WorkspaceResources.sender_column_header, new Object[0]));
        JXLabel createdOnLabel = new JXLabel(i18n.text(WorkspaceResources.created_column_header, new Object[0]));
        authorLabel.setForeground(Color.GRAY);
        createdOnLabel.setForeground(Color.GRAY);
        this.attachmentsView = (MessageAttachmentsView)module.objectBuilderFactory().newObjectBuilder(MessageAttachmentsView.class).use(new Object[]{model.newMessageAttachmentsModel()}).newInstance();
        this.attachmentsView.setLayout(new WrapLayout(0));
        this.authorLabelValue = new JXLabel();
        this.createdOnLabelValue = new JXLabel();
        formBuilder.setExtent(1, 1);
        formBuilder.add((Component)authorLabel);
        formBuilder.nextColumn(2);
        formBuilder.add((Component)this.valueBinder.bind("sender", this.authorLabelValue));
        formBuilder.nextLine();
        formBuilder.add((Component)createdOnLabel);
        formBuilder.nextColumn(2);
        formBuilder.add((Component)this.createdOnLabelValue);
        messageDetailButtonPanel.add((Component)closeButtonPanel, "East");
        JScrollPane pane = new JScrollPane(this.attachmentsView);
        pane.setPreferredSize(new Dimension(500, 40));
        pane.setBorder(BorderFactory.createEmptyBorder());
        messageDetailButtonPanel.add((Component)pane, "Center");
        messageDetailButtonPanel.add((Component)messageDetailsLabelPanel, "West");
        this.showMessage = new JTextPane();
        this.valueBinder.bind("text", this.showMessage);
        this.showMessage.setEditable(false);
        messageShowScroll.getViewport().add(this.showMessage);
        this.add((Component)messageShowScroll, "Center");
        this.add((Component)messageDetailButtonPanel, "North");
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        if (MessageType.HTML.equals(this.model.getMessageDTO().messageType().get())) {
            this.showMessage.setContentType("text/html");
            this.showMessage.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
        } else {
            this.showMessage.setContentType("text/plain");
        }
        this.valueBinder.update((ValueComposite)this.model.getMessageDTO());
        this.createdOnLabelValue.setText(DateFormats.getFullDateTimeValue((Date)this.model.getMessageDTO().createdOn().get(), Locale.getDefault()));
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdMessage"}), transactions)) {
            this.model.refresh();
        }
    }

    public void read() {
        new CommandTask(){

            @Override
            protected void command() throws Exception {
                MessageView.this.model.read();
            }
        }.execute();
    }
}

