/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageDraftAttachmentsView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageDraftModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.ValueBinder;

public class MessageDraftView
extends JPanel
implements Refreshable {
    MessageDraftModel model;
    private JTextPane newMessage;
    ValueBinder valueBinder;
    MessageDraftAttachmentsView attachmentsView;

    public MessageDraftView(@Service ApplicationContext context, @Structure Module module, @Uses MessageDraftModel model) {
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 250));
        JScrollPane messageScroll = new JScrollPane();
        this.newMessage = new JTextPane();
        this.newMessage.setContentType("text/plain");
        this.newMessage.setEditable(true);
        messageScroll.getViewport().add(this.newMessage);
        this.valueBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.valueBinder.bind("string", this.newMessage);
        FormLayout formLayout = new FormLayout("fill:pref:grow, 4dlu, min", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        this.attachmentsView = (MessageDraftAttachmentsView)module.objectBuilderFactory().newObjectBuilder(MessageDraftAttachmentsView.class).use(new Object[]{model.newMessageDraftAttachmentsModel()}).newInstance();
        panelBuilder.add((Component)this.attachmentsView);
        panelBuilder.nextColumn(2);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        javax.swing.Action createMessageAction = context.getActionMap().get((Object)"createMessage");
        StreamflowButton createMessage = new StreamflowButton(createMessageAction);
        createMessage.registerKeyboardAction(createMessageAction, (KeyStroke)createMessageAction.getValue("AcceleratorKey"), 2);
        javax.swing.Action cancelAction = context.getActionMap().get((Object)"cancelNewMessage");
        StreamflowButton cancel = new StreamflowButton(cancelAction);
        buttonPanel.add(createMessage);
        buttonPanel.add(cancel);
        panelBuilder.add((Component)buttonPanel);
        this.add((Component)messageScroll, "Center");
        this.add((Component)panelBuilder.getPanel(), "South");
        new ActionBinder(this.getActionMap()).bind("changeMessage", this.newMessage);
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.valueBinder.update((ValueComposite)this.model.getDraftMessage());
        this.newMessage.requestFocusInWindow();
    }

    @Action
    public Task changeMessage() {
        final String message = this.newMessage.getText();
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                MessageDraftView.this.model.changeMessage(message);
            }
        };
    }
}

