/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.cases.attachment.AttachmentDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsModel;
import se.streamsource.streamflow.client.util.OpenAttachmentTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class MessageAttachmentsView
extends JPanel
implements Refreshable {
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    Map<StreamflowButton, AttachmentDTO> openFileMap = new HashMap<StreamflowButton, AttachmentDTO>();
    private AttachmentsModel model;
    ActionMap am;

    public MessageAttachmentsView(@Service ApplicationContext context, @Uses AttachmentsModel model) {
        this.model = model;
        this.am = context.getActionMap((Object)this);
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.removeAll();
        this.openFileMap.clear();
        this.model.refresh();
        Iterator iterator = this.model.getEventList().iterator();
        while (iterator.hasNext()) {
            AttachmentDTO attachmentIn;
            AttachmentDTO attachment = attachmentIn = (AttachmentDTO)iterator.next();
            StreamflowButton attachmentButton = new StreamflowButton((String)attachment.text().get(), i18n.icon(Icons.attachments, 14));
            attachmentButton.setBorder(BorderFactory.createEmptyBorder());
            this.openFileMap.put(attachmentButton, attachment);
            attachmentButton.addActionListener(this.am.get("open"));
            this.add(attachmentButton);
        }
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task open(ActionEvent e) throws IOException {
        AttachmentDTO attachment = this.openFileMap.get(e.getSource());
        return new OpenAttachmentTask((String)attachment.text().get(), (String)attachment.href().get(), this, this.model, this.dialogs);
    }
}

