/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.data.Form;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.conversation.ConversationDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ConversationsModel
extends Observable
implements Refreshable,
TransactionListener {
    @Uses
    CommandQueryClient client;
    @Structure
    Module module;
    TransactionList<ConversationDTO> conversations = new TransactionList((EventList)new BasicEventList());

    @Override
    public void refresh() {
        ResourceValue resource = this.client.query();
        LinksValue newConversations = (LinksValue)resource.index().get();
        EventListSynch.synchronize((Collection)newConversations.links().get(), this.conversations);
        this.setChanged();
        this.notifyObservers(resource);
    }

    public EventList<ConversationDTO> conversations() {
        return this.conversations;
    }

    public void createConversation(String topic) {
        ValueBuilder newTopic = ((StringValue)this.module.valueBuilderFactory().newValue(StringValue.class)).buildWith();
        ((StringValue)newTopic.prototype()).string().set((Object)topic);
        Form form = new Form();
        form.set("topic", topic);
        this.client.postCommand("create", (Object)form);
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.or((Specification[])new Specification[]{Events.onEntities((String[])new String[]{this.client.getReference().getParentRef().getLastSegment()}), Events.onEntities(this.conversations), Events.withNames((String[])new String[]{"setUnread"})}), transactions)) {
            this.refresh();
        }
    }

    public ConversationModel newConversationModel(LinkValue selectedValue) {
        return (ConversationModel)this.module.objectBuilderFactory().newObjectBuilder(ConversationModel.class).use(new Object[]{this.client.getClient(selectedValue)}).newInstance();
    }
}

