/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactDTO;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.UncaughtExceptionHandler;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ContactsView
extends JPanel
implements TransactionListener,
Refreshable {
    @Service
    UncaughtExceptionHandler exception;
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private ContactsModel model;
    private JList contacts;

    public ContactsView(@Service ApplicationContext context, @Uses ContactsModel model) {
        super(new BorderLayout());
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.setPreferredSize(new Dimension(200, 0));
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.contacts = new JList(new EventListModel(model.getEventList()));
        this.contacts.setPreferredSize(new Dimension(200, 1000));
        this.contacts.setSelectionMode(0);
        JScrollPane contactsScrollPane = new JScrollPane();
        contactsScrollPane.setViewportView(this.contacts);
        this.contacts.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                ContactDTO contact = (ContactDTO)o;
                if ("".equals(contact.name().get())) {
                    Component cell = super.getListCellRendererComponent((JList<?>)jList, i18n.text(WorkspaceResources.name_label, new Object[0]), i, b, b1);
                    cell.setForeground(Color.GRAY);
                    return cell;
                }
                String text = (String)contact.name().get();
                return super.getListCellRendererComponent((JList<?>)jList, text, i, b, b1);
            }
        });
        this.add((Component)contactsScrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(am.get("remove")));
        this.add((Component)toolbar, "South");
        model.addObserver(new RefreshComponents().visibleOn("add", toolbar));
        this.contacts.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        new RefreshWhenShowing(this, this);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task add() throws IOException, ResourceException {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                ContactsView.this.model.createContact();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task remove() throws IOException, ResourceException {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)((ContactDTO)this.contacts.getSelectedValue()).name().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ContactsView.this.model.removeElement(ContactsView.this.getContactsList().getSelectedIndex());
                }
            };
        }
        return null;
    }

    public JList getContactsList() {
        return this.contacts;
    }

    @Override
    public void refresh() {
        this.model.refresh();
        if (this.model.getEventList().size() > 0 && this.contacts.getSelectedIndex() == -1) {
            this.contacts.setSelectedIndex(0);
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedStatus", "addedContact", "deletedContact", "updatedContact"}), transactions)) {
            this.refresh();
            if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedContact"}), transactions)) {
                this.contacts.setSelectedIndex(this.contacts.getModel().getSize() - 1);
            } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"updatedContact"}), transactions)) {
                this.model.getCurrentContact().setContact(this.model.createInitialValues((ContactDTO)this.model.getEventList().get(this.contacts.getSelectedIndex())));
            } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"deletedContact"}), transactions) && this.model.getEventList().size() >= 0) {
                this.contacts.setSelectedIndex(0);
            }
        }
    }

    public ContactsModel getModel() {
        return this.model;
    }
}

