/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.property.Property;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactAddressDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactEmailDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPhoneDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPreference;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactsDTO;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactLookupResultDialog;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactModel;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.StreetAddressSuggestModel;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.StreetAddressSuggestTextField;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class ContactView
extends JPanel
implements Observer {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private StateBinder contactBinder;
    private StateBinder phoneNumberBinder;
    private StateBinder emailBinder;
    private StateBinder addressBinder;
    ContactModel model;
    private CardLayout layout = new CardLayout();
    public JPanel form;
    private JTextField defaultFocusField;
    private JTextField addressField;
    private StreetAddressSuggestTextField suggestAddress;
    private JTextField zipField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField cityField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField regionField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField countryField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField phoneField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField emailField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField contactIdField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JTextField companyField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
    private JComboBox contactPreferenceField = (JComboBox)BindingFormBuilder.Fields.COMBOBOX.newField();
    private JLabel contactPreferenceLabel = new JLabel();
    private ApplicationContext context;
    private JPanel lookupPanel;
    private ValueBinder viewBinder;
    private ValueBinder phoneViewBinder;
    private ValueBinder addressViewBinder;
    private ValueBinder emailViewBinder;
    private StreetAddressSuggestModel suggestModel;

    public ContactView(@Service ApplicationContext appContext, @Structure Module module) {
        this.setLayout(this.layout);
        this.context = appContext;
        this.setActionMap((ActionMap)this.context.getActionMap((Object)this));
        this.add((Component)new JLabel(), "EMPTY");
        DefaultComboBoxModel<ContactPreference> contactPreferenceModel = new DefaultComboBoxModel<ContactPreference>();
        for (ContactPreference preference : ContactPreference.values()) {
            contactPreferenceModel.addElement(preference);
        }
        this.contactPreferenceField.setModel(contactPreferenceModel);
        this.contactPreferenceField.setSelectedIndex(0);
        this.contactPreferenceField.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                JLabel comp = new JLabel("null");
                if (o instanceof ContactPreference) {
                    comp = (ContactPreference)o == ContactPreference.none ? new JLabel(" ") : new JLabel(i18n.text(WorkspaceResources.valueOf(((ContactPreference)o).name()), new Object[0]));
                }
                comp.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 0));
                return comp;
            }
        });
        this.viewBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.phoneViewBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.addressViewBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.emailViewBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.suggestModel = new StreetAddressSuggestModel();
        this.suggestAddress = new StreetAddressSuggestTextField(this.suggestModel, this.cityField, this.addressViewBinder);
        this.addressField = this.suggestAddress.getTextField();
        FormLayout formLayout = new FormLayout("right:70dlu, 5dlu, 150dlu:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, 5dlu, top:70dlu:grow, pref, pref");
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.form = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.form);
        scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout, this.form);
        this.contactBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.contactBinder.setResourceMap(this.context.getResourceMap(this.getClass()));
        ContactDTO template = this.contactBinder.bindingTemplate(ContactDTO.class);
        this.phoneNumberBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.phoneNumberBinder.setResourceMap(this.context.getResourceMap(this.getClass()));
        ContactPhoneDTO phoneTemplate = this.phoneNumberBinder.bindingTemplate(ContactPhoneDTO.class);
        this.addressBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.addressBinder.setResourceMap(this.context.getResourceMap(this.getClass()));
        ContactAddressDTO addressTemplate = this.addressBinder.bindingTemplate(ContactAddressDTO.class);
        this.emailBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.emailBinder.setResourceMap(this.context.getResourceMap(this.getClass()));
        ContactEmailDTO emailTemplate = this.emailBinder.bindingTemplate(ContactEmailDTO.class);
        builder.add((Component)new StreamflowButton(this.getActionMap().get("view")));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.name_label));
        builder.nextColumn(2);
        this.defaultFocusField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        builder.add((Component)this.contactBinder.bind(this.defaultFocusField, template.name()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.phone_label));
        builder.nextColumn(2);
        builder.add((Component)this.phoneNumberBinder.bind(this.phoneField, phoneTemplate.phoneNumber()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.address_label));
        builder.nextColumn(2);
        builder.add((Component)this.suggestAddress);
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.zip_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressBinder.bind(this.zipField, addressTemplate.zipCode()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.city_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressBinder.bind(this.cityField, addressTemplate.city()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.region_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressBinder.bind(this.regionField, addressTemplate.region()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.country_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressBinder.bind(this.countryField, addressTemplate.country()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.email_label));
        builder.nextColumn(2);
        builder.add((Component)this.emailBinder.bind(this.emailField, emailTemplate.emailAddress()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.contact_id_label));
        builder.nextColumn(2);
        builder.add((Component)this.contactBinder.bind(this.contactIdField, template.contactId()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.company_label));
        builder.nextColumn(2);
        builder.add((Component)this.contactBinder.bind(this.companyField, template.company()));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.contact_preference_label));
        builder.nextColumn(2);
        builder.add((Component)this.contactBinder.bind(this.contactPreferenceField, template.contactPreference()), new CellConstraints(3, 12, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(5, 0, 0, 0)));
        builder.nextLine(2);
        builder.add((Component)this.createLabel(WorkspaceResources.note_label));
        builder.nextColumn(2);
        builder.add(this.contactBinder.bind(BindingFormBuilder.Fields.TEXTAREA.newField(), template.note()));
        builder.nextLine(2);
        builder.nextColumn(2);
        this.lookupPanel = new JPanel(new FlowLayout(1));
        this.lookupPanel.add(new StreamflowButton(this.getActionMap().get("lookupContact")));
        builder.add((Component)this.lookupPanel);
        this.contactBinder.addObserver(this);
        this.phoneNumberBinder.addObserver(this);
        this.addressBinder.addObserver(this);
        this.emailBinder.addObserver(this);
        this.add((Component)scrollPane, "EDIT");
        formLayout = new FormLayout("right:70dlu, 5dlu, 150dlu:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, 5dlu, top:70dlu:grow, pref, pref");
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.form = new JPanel();
        scrollPane = new JScrollPane(this.form);
        scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        builder = new DefaultFormBuilder(formLayout, this.form);
        builder.add((Component)new StreamflowButton(this.getActionMap().get("edit")));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.name_label));
        builder.nextColumn(2);
        builder.add((Component)this.viewBinder.bind("name", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.phone_label));
        builder.nextColumn(2);
        builder.add((Component)this.phoneViewBinder.bind("phoneNumber", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.address_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressViewBinder.bind("address", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.zip_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressViewBinder.bind("zipCode", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.city_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressViewBinder.bind("city", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.region_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressViewBinder.bind("region", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.country_label));
        builder.nextColumn(2);
        builder.add((Component)this.addressViewBinder.bind("country", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.email_label));
        builder.nextColumn(2);
        builder.add((Component)this.emailViewBinder.bind("emailAddress", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.contact_id_label));
        builder.nextColumn(2);
        builder.add((Component)this.viewBinder.bind("contactId", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.company_label));
        builder.nextColumn(2);
        builder.add((Component)this.viewBinder.bind("company", this.visibleIfNotEmpty(new JLabel("!"))));
        builder.nextLine();
        builder.add((Component)this.createLabel(WorkspaceResources.contact_preference_label));
        builder.nextColumn(2);
        builder.add((Component)this.contactPreferenceLabel);
        builder.nextLine(2);
        builder.add((Component)this.createLabel(WorkspaceResources.note_label));
        builder.nextColumn(2);
        builder.add((Component)this.viewBinder.bind("note", this.visibleIfNotEmpty(new JLabel("!"))));
        this.add((Component)scrollPane, "VIEW");
    }

    private JLabel createLabel(Enum key) {
        JLabel label = new JLabel(i18n.text(key, new Object[0]));
        label.setForeground(Color.gray);
        return label;
    }

    public void setModel(ContactModel model) {
        this.model = model;
        if (model != null) {
            this.updateFromModel(model);
            javax.swing.Action action = this.getActionMap().get("lookupContact");
            action.setEnabled(model.isContactLookupEnabled());
            this.lookupPanel.setVisible(action.isEnabled());
            if (model.getContact().toJSON().equals("{\"addresses\":[{\"address\":\"\",\"city\":\"\",\"contactType\":\"HOME\",\"country\":\"\",\"region\":\"\",\"zipCode\":\"\"}],\"company\":\"\",\"contactId\":\"\",\"contactPreference\":\"none\",\"emailAddresses\":[{\"contactType\":\"HOME\",\"emailAddress\":\"\"}],\"isCompany\":false,\"name\":\"\",\"note\":\"\",\"phoneNumbers\":[{\"contactType\":\"HOME\",\"phoneNumber\":\"\"}],\"picture\":\"\"}")) {
                this.layout.show(this, "EDIT");
            } else {
                this.layout.show(this, "VIEW");
            }
        } else {
            this.layout.show(this, "EMPTY");
        }
    }

    public void updateFromModel(ContactModel model) {
        this.handleContactPreference();
        this.suggestModel.setContactModel(model);
        this.contactBinder.updateWith(model.getContact());
        this.phoneNumberBinder.updateWith(model.getPhoneNumber());
        this.addressBinder.updateWith(model.getAddress());
        this.suggestAddress.getTextField().setText(model.getAddress().address() != null ? (String)model.getAddress().address().get() : "");
        this.emailBinder.updateWith(model.getEmailAddress());
        this.viewBinder.update((ValueComposite)model.getContact());
        this.phoneViewBinder.update((ValueComposite)model.getPhoneNumber());
        this.addressViewBinder.update((ValueComposite)model.getAddress());
        this.emailViewBinder.update((ValueComposite)model.getEmailAddress());
    }

    @Override
    public void update(Observable observable, Object arg) {
        final Property property = (Property)arg;
        new CommandTask(){

            @Override
            public void command() throws Exception {
                String propertyName = property.qualifiedName().name();
                if (propertyName.equals("name")) {
                    ContactView.this.model.changeName((String)property.get());
                } else if (propertyName.equals("note")) {
                    ContactView.this.model.changeNote((String)property.get());
                } else if (propertyName.equals("company")) {
                    ContactView.this.model.changeCompany((String)property.get());
                } else if (propertyName.equals("phoneNumber")) {
                    ContactView.this.model.changePhoneNumber((String)property.get());
                } else if (propertyName.equals("address")) {
                    ContactView.this.model.changeAddress((String)property.get());
                } else if (propertyName.equals("zipCode")) {
                    ContactView.this.model.changeZipCode((String)property.get());
                } else if (propertyName.equals("city")) {
                    ContactView.this.model.changeCity((String)property.get());
                } else if (propertyName.equals("region")) {
                    ContactView.this.model.changeRegion((String)property.get());
                } else if (propertyName.equals("country")) {
                    ContactView.this.model.changeCountry((String)property.get());
                } else if (propertyName.equals("emailAddress")) {
                    ContactView.this.model.changeEmailAddress((String)property.get());
                } else if (propertyName.equals("contactId")) {
                    ContactView.this.model.changeContactId((String)property.get());
                } else if (propertyName.equals("contactPreference")) {
                    if (property.get() instanceof ContactPreference) {
                        ContactView.this.model.changeContactPreference((ContactPreference)property.get());
                    } else {
                        ContactView.this.model.changeContactPreference(null);
                    }
                }
            }
        }.execute();
    }

    @Action
    public void edit() {
        this.layout.show(this, "EDIT");
    }

    @Action
    public void view() {
        this.setModel(this.model);
        this.layout.show(this, "VIEW");
    }

    @Action
    public void lookupContact() {
        try {
            ContactDTO query = this.createContactQuery();
            ContactDTO emptyCriteria = (ContactDTO)this.module.valueBuilderFactory().newValueBuilder(ContactDTO.class).newInstance();
            if (emptyCriteria.equals(query)) {
                String msg = i18n.text(CaseResources.could_not_find_search_criteria, new Object[0]);
                this.dialogs.showMessageDialog(this, msg, "Info");
            } else {
                ContactsDTO contacts = this.model.searchContacts(query);
                if (((List)contacts.contacts().get()).isEmpty()) {
                    String msg = i18n.text(CaseResources.could_not_find_contacts, new Object[0]);
                    this.dialogs.showMessageDialog(this, msg, "Info");
                } else {
                    ContactLookupResultDialog dialog = (ContactLookupResultDialog)this.module.objectBuilderFactory().newObjectBuilder(ContactLookupResultDialog.class).use(new Object[]{contacts.contacts().get()}).newInstance();
                    this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), dialog, i18n.text(WorkspaceResources.contacts_tab, new Object[0]));
                    ContactDTO contactValue = dialog.getSelectedContact();
                    if (contactValue != null) {
                        if (this.defaultFocusField.getText().equals("") && !((String)contactValue.name().get()).equals("")) {
                            this.model.changeName((String)contactValue.name().get());
                            this.defaultFocusField.setText((String)contactValue.name().get());
                        }
                        for (Object contactPhoneDTO : (List)contactValue.phoneNumbers().get()) {
                            if (((String)contactPhoneDTO.phoneNumber().get()).equals("") || !((String)this.model.getPhoneNumber().phoneNumber().get()).equals("")) continue;
                            this.model.changePhoneNumber((String)contactPhoneDTO.phoneNumber().get());
                            this.phoneField.setText((String)contactPhoneDTO.phoneNumber().get());
                        }
                        List addressDTOs = (List)contactValue.addresses().get();
                        for (ContactAddressDTO addressDTO : addressDTOs) {
                            if (((String)addressDTO.address().get()).equals("") || !((String)this.model.getAddress().address().get()).equals("")) continue;
                            this.model.changeAddress((String)addressDTO.address().get());
                            this.addressField.setText((String)addressDTO.address().get());
                        }
                        List emailDTOs = (List)contactValue.emailAddresses().get();
                        for (ContactEmailDTO emailDTO : emailDTOs) {
                            if (((String)emailDTO.emailAddress().get()).equals("") || !((String)this.model.getEmailAddress().emailAddress().get()).equals("")) continue;
                            this.model.changeEmailAddress((String)emailDTO.emailAddress().get());
                            this.emailField.setText((String)emailDTO.emailAddress().get());
                        }
                        if (this.contactIdField.getText().equals("") && !((String)contactValue.contactId().get()).equals("")) {
                            this.model.changeContactId((String)contactValue.contactId().get());
                            this.contactIdField.setText((String)contactValue.contactId().get());
                        }
                        if (this.companyField.getText().equals("") && !((String)contactValue.company().get()).equals("")) {
                            this.model.changeCompany((String)contactValue.company().get());
                            this.companyField.setText((String)contactValue.company().get());
                        }
                    }
                }
            }
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }

    private ContactDTO createContactQuery() {
        ValueBuilder builder;
        ValueBuilder contactBuilder = this.module.valueBuilderFactory().newValueBuilder(ContactDTO.class);
        if (!this.defaultFocusField.getText().isEmpty()) {
            ((ContactDTO)contactBuilder.prototype()).name().set((Object)this.defaultFocusField.getText());
        }
        if (!this.phoneField.getText().isEmpty()) {
            builder = this.module.valueBuilderFactory().newValueBuilder(ContactPhoneDTO.class);
            ((ContactPhoneDTO)builder.prototype()).phoneNumber().set((Object)this.phoneField.getText());
            ((List)((ContactDTO)contactBuilder.prototype()).phoneNumbers().get()).add(builder.newInstance());
        }
        if (!this.addressField.getText().isEmpty()) {
            builder = this.module.valueBuilderFactory().newValueBuilder(ContactAddressDTO.class);
            ((ContactAddressDTO)builder.prototype()).address().set((Object)this.addressField.getText());
            ((List)((ContactDTO)contactBuilder.prototype()).addresses().get()).add(builder.newInstance());
        }
        if (!this.emailField.getText().isEmpty()) {
            builder = this.module.valueBuilderFactory().newValueBuilder(ContactEmailDTO.class);
            ((ContactEmailDTO)builder.prototype()).emailAddress().set((Object)this.emailField.getText());
            ((List)((ContactDTO)contactBuilder.prototype()).emailAddresses().get()).add(builder.newInstance());
        }
        if (!this.contactIdField.getText().isEmpty()) {
            ((ContactDTO)contactBuilder.prototype()).contactId().set((Object)this.contactIdField.getText());
        }
        if (!this.companyField.getText().isEmpty()) {
            ((ContactDTO)contactBuilder.prototype()).contactId().set((Object)this.contactIdField.getText());
        }
        return (ContactDTO)contactBuilder.newInstance();
    }

    private void handleContactPreference() {
        ContactPreference val = (ContactPreference)this.model.getContact().contactPreference().get();
        if (val == null) {
            this.model.getContact().contactPreference().set((Object)ContactPreference.none);
            val = (ContactPreference)this.model.getContact().contactPreference().get();
        }
        if (val == ContactPreference.none) {
            this.contactPreferenceLabel.setVisible(false);
        } else {
            this.contactPreferenceLabel.setVisible(true);
            this.contactPreferenceLabel.setText(i18n.text(WorkspaceResources.valueOf(val.name()), new Object[0]));
        }
        this.alignSibling(this.contactPreferenceLabel);
    }

    private JLabel visibleIfNotEmpty(final JLabel label) {
        label.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                label.setVisible(!evt.getNewValue().equals(""));
                ContactView.this.alignSibling(label);
            }
        });
        return label;
    }

    private void alignSibling(JLabel label) {
        Container container = label.getParent();
        for (int i = 0; i < container.getComponents().length; ++i) {
            Component component = container.getComponents()[i];
            if (component != label) continue;
            JLabel labelForLabel = (JLabel)container.getComponent(i - 1);
            labelForLabel.setVisible(label.isVisible());
        }
    }

    public void setFocusOnName() {
        this.defaultFocusField.requestFocusInWindow();
    }
}

