/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactEmailDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPhoneDTO;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.i18n;

public class ContactLookupResultFieldsValueModel
extends AbstractTableModel {
    String[] columnNames = new String[]{i18n.text(WorkspaceResources.name_label, new Object[0]), i18n.text(WorkspaceResources.contact_id_label, new Object[0]), i18n.text(WorkspaceResources.phone_label, new Object[0]), i18n.text(WorkspaceResources.email_label, new Object[0])};
    List<ContactDTO> contacts = Collections.emptyList();

    public ContactLookupResultFieldsValueModel(List<ContactDTO> contacts) {
        this.contacts = contacts;
    }

    @Override
    public int getRowCount() {
        return this.contacts == null ? 0 : this.contacts.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ContactDTO value = this.contacts.get(row);
        switch (col) {
            case 0: {
                return value.name().get();
            }
            case 1: {
                return value.contactId().get();
            }
            case 2: {
                if (((List)value.phoneNumbers().get()).isEmpty()) {
                    return "";
                }
                return ((ContactPhoneDTO)((List)value.phoneNumbers().get()).get(0)).phoneNumber();
            }
            case 3: {
                if (((List)value.emailAddresses().get()).isEmpty()) {
                    return "";
                }
                return ((ContactEmailDTO)((List)value.emailAddresses().get()).get(0)).emailAddress();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    public ContactDTO getContactValueAt(int index) {
        try {
            return this.contacts.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }
}

