/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.caselog;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryDTO;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryTypes;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.util.Strings;

public class CaseLogListCellRenderer
implements ListCellRenderer {
    private JLabel conversationIcon;
    private JLabel myPagesPublishedIcon = new JLabel(i18n.icon(Icons.published, 16));
    private JLabel systemIcon;
    private JLabel customIcon;
    private JLabel contactIcon;
    private JLabel formIcon;
    private JLabel attachmentIcon;

    public CaseLogListCellRenderer() {
        this.myPagesPublishedIcon.setText(" ");
        this.systemIcon = new JLabel(i18n.icon(Icons.history, 16));
        this.customIcon = new JLabel(i18n.icon(Icons.message_add, 16));
        this.contactIcon = new JLabel(i18n.icon(Icons.projects, 16));
        this.formIcon = new JLabel(i18n.icon(Icons.forms, 16));
        this.conversationIcon = new JLabel(i18n.icon(Icons.conversations, 16));
        this.attachmentIcon = new JLabel(i18n.icon(Icons.attachments, 16));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        CaseLogEntryDTO entry = (CaseLogEntryDTO)value;
        JPanel renderer = new JPanel(new BorderLayout());
        FormLayout rowLayout = new FormLayout("30dlu, pref:grow, pref", "pref, fill:pref:grow");
        renderer.setLayout((LayoutManager)rowLayout);
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(rowLayout, renderer);
        renderer.setBorder(new EmptyBorder(3, 3, 6, 3));
        JPanel icons = new JPanel(new BorderLayout());
        icons.setOpaque(false);
        if (((Boolean)entry.myPagesVisibility().get()).booleanValue()) {
            icons.add((Component)this.myPagesPublishedIcon, "West");
        }
        switch ((CaseLogEntryTypes)entry.caseLogType().get()) {
            case system: {
                icons.add((Component)this.systemIcon, "East");
                break;
            }
            case custom: {
                icons.add((Component)this.customIcon, "East");
                break;
            }
            case contact: {
                icons.add((Component)this.contactIcon, "East");
                break;
            }
            case form: {
                icons.add((Component)this.formIcon, "East");
                break;
            }
            case conversation: {
                icons.add((Component)this.conversationIcon, "East");
                break;
            }
            case attachment: {
                icons.add((Component)this.attachmentIcon, "East");
                break;
            }
        }
        formBuilder.add((Component)icons, new CellConstraints(1, 1, 1, 2, CellConstraints.RIGHT, CellConstraints.TOP, new Insets(0, 0, 0, 10)));
        JLabel user = new JLabel((String)entry.creator().get());
        user.setForeground(Color.GRAY);
        formBuilder.add((Component)user, new CellConstraints(2, 1, 1, 1, CellConstraints.LEFT, CellConstraints.TOP));
        JLabel date = new JLabel(DateFormats.getProgressiveDateTimeValue((Date)entry.creationDate().get(), Locale.getDefault()));
        date.setForeground(Color.GRAY);
        formBuilder.add((Component)date, new CellConstraints(3, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.TOP));
        String entryMessage = (String)entry.message().get();
        if (!Strings.empty((String)entryMessage)) {
            entryMessage = String.format("<html><div WIDTH=%d>%s</div><html>", 500, entryMessage.trim().replace("\n", "<br>"));
        }
        JLabel message = new JLabel(entryMessage);
        message.setForeground(Color.BLACK);
        formBuilder.add((Component)message, new CellConstraints(2, 2, 2, 1, CellConstraints.LEFT, CellConstraints.TOP));
        return renderer;
    }
}

