/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.attachments;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import se.streamsource.streamflow.api.workspace.cases.attachment.AttachmentDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.i18n;

public class AttachmentsTableFormatter
implements AdvancedTableFormat<AttachmentDTO> {
    protected String[] columnNames = new String[]{"", i18n.text(WorkspaceResources.attachment_name, new Object[0]), i18n.text(WorkspaceResources.attachment_size, new Object[0]), i18n.text(WorkspaceResources.created_column_header, new Object[0])};
    protected Class[] columnClasses = new Class[]{Icons.class, String.class, String.class, Date.class};

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    public Class getColumnClass(int i) {
        return this.columnClasses[i];
    }

    public Comparator getColumnComparator(int i) {
        return null;
    }

    public Object getColumnValue(AttachmentDTO attachmentDTO, int i) {
        switch (i) {
            case 0: {
                String rel = (String)attachmentDTO.rel().get();
                if ("attachment".equals(rel)) {
                    return Icons.attachments;
                }
                if ("conversation".equals(rel)) {
                    return Icons.conversations;
                }
                if (!"submittedform".equals(rel)) break;
                return Icons.formSubmitted;
            }
            case 1: {
                return attachmentDTO.text().get();
            }
            case 2: {
                try {
                    long size = (Long)attachmentDTO.size().get();
                    if (size > 1024000L) {
                        return size / 1024000L + " MB";
                    }
                    if (size > 1024L) {
                        return size / 1024L + " KB";
                    }
                    return size + "";
                }
                catch (Exception e) {
                    return "";
                }
            }
            case 3: {
                return attachmentDTO.modificationDate().get() == null ? "" : DateFormat.getDateInstance(2).format((Date)attachmentDTO.modificationDate().get());
            }
        }
        return null;
    }
}

