/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.overview;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.swingx.JXFrame;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.ui.account.AccountSelector;
import se.streamsource.streamflow.client.ui.menu.OverviewMenuBar;
import se.streamsource.streamflow.client.ui.overview.OverviewResources;
import se.streamsource.streamflow.client.ui.overview.OverviewView;
import se.streamsource.streamflow.client.util.JavaHelp;
import se.streamsource.streamflow.client.util.i18n;

public class OverviewWindow
extends FrameView {
    public OverviewWindow(@Service Application application, @Service JavaHelp javaHelp, @Uses OverviewMenuBar menu, final @Structure Module module, final @Uses AccountSelector accountSelector) {
        super(application);
        final JXFrame frame = new JXFrame(i18n.text(OverviewResources.window_name, new Object[0]));
        frame.setLocationByPlatform(true);
        this.setFrame((JFrame)frame);
        this.setMenuBar(menu);
        frame.setPreferredSize(new Dimension(1300, 800));
        frame.pack();
        accountSelector.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (accountSelector.isSelectionEmpty()) {
                        frame.getContentPane().removeAll();
                    } else {
                        frame.getContentPane().removeAll();
                        AccountModel selectedAccount = accountSelector.getSelectedAccount();
                        OverviewView overviewView = (OverviewView)module.objectBuilderFactory().newObjectBuilder(OverviewView.class).use(new Object[]{selectedAccount.newOverviewModel(), selectedAccount.newWorkspaceModel().newCasesModel()}).newInstance();
                        frame.getContentPane().add(overviewView);
                    }
                }
            }
        });
    }
}

