/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.overview;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXTable;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.io.Inputs;
import org.qi4j.api.io.Outputs;
import org.restlet.representation.Representation;
import se.streamsource.dci.value.table.CellValue;
import se.streamsource.dci.value.table.RowValue;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.overview.OverviewResources;
import se.streamsource.streamflow.client.ui.overview.OverviewSummaryModel;
import se.streamsource.streamflow.client.util.FileNameExtensionFilter;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class OverviewSummaryView
extends JPanel {
    @Service
    protected DialogService dialogs;
    @Service
    protected StreamflowApplication application;
    protected JXTable overviewSummaryTable;
    protected OverviewSummaryModel model;

    public void init(@Service ApplicationContext context, @Uses OverviewSummaryModel model) {
        this.model = model;
        this.setLayout(new BorderLayout());
        ApplicationActionMap am = context.getActionMap(OverviewSummaryView.class, (Object)this);
        this.setActionMap((ActionMap)am);
        this.overviewSummaryTable = new JXTable((TableModel)new EventJXTableModel(model.getProjectOverviews(), (TableFormat)new TableFormat<RowValue>(){
            String[] columnNames = new String[]{i18n.text(OverviewResources.project_column_header, new Object[0]), i18n.text(OverviewResources.inbox_column_header, new Object[0]), i18n.text(OverviewResources.assigned_column_header, new Object[0]), i18n.text(OverviewResources.total_column_header, new Object[0])};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public String getColumnName(int i) {
                return this.columnNames[i];
            }

            public Object getColumnValue(RowValue o, int i) {
                switch (i) {
                    case 0: {
                        return ((CellValue)((List)o.c().get()).get(0)).f().get();
                    }
                    case 1: {
                        return ((CellValue)((List)o.c().get()).get(1)).f().get();
                    }
                    case 2: {
                        return ((CellValue)((List)o.c().get()).get(2)).f().get();
                    }
                    case 3: {
                        return (String)((CellValue)((List)o.c().get()).get(1)).f().get() + (String)((CellValue)((List)o.c().get()).get(2)).f().get();
                    }
                }
                return null;
            }
        }));
        this.overviewSummaryTable.getActionMap().getParent().setParent((ActionMap)am);
        this.overviewSummaryTable.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.overviewSummaryTable.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        JScrollPane overviewSummaryScrollPane = new JScrollPane((Component)this.overviewSummaryTable);
        this.overviewSummaryTable.setAutoCreateColumnsFromModel(false);
        JPanel toolBar = new JPanel();
        this.addToolbarButton(toolBar, "export");
        this.add((Component)overviewSummaryScrollPane, "Center");
        this.add((Component)toolBar, "South");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                OverviewSummaryView.this.overviewSummaryTable.requestFocusInWindow();
            }
        });
        new RefreshWhenShowing(this, model);
    }

    protected javax.swing.Action addToolbarButton(JPanel toolbar, String name) {
        ActionMap am = this.getActionMap();
        javax.swing.Action action = am.get(name);
        action.putValue("SmallIcon", i18n.icon((ImageIcon)action.getValue("SmallIcon"), 16));
        toolbar.add(new StreamflowButton(action));
        return action;
    }

    @Action
    public void export() throws Exception {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(i18n.text(StreamflowResources.excel_file, new Object[0]), true, "xls"));
        int returnVal = fileChooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        Representation representation = this.model.generateExcelProjectSummary();
        File file = fileChooser.getSelectedFile();
        Inputs.byteBuffer((InputStream)representation.getStream(), (int)8192).transferTo(Outputs.byteBuffer((File)file));
        int response = JOptionPane.showConfirmDialog(this, i18n.text(StreamflowResources.export_data_file_with_open_option, new Object[0]), i18n.text(StreamflowResources.export_completed, new Object[0]), 0, 3);
        if (response == 0) {
            Runtime.getRuntime().exec(new String[]{"open", file.getAbsolutePath()});
        }
    }
}

