/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.restlet.data.Form;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.administration.NewProxyUserDTO;
import se.streamsource.streamflow.api.administration.ProxyUserDTO;
import se.streamsource.streamflow.api.administration.ProxyUserListDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class ProxyUsersModel
implements Refreshable,
TransactionListener {
    @Structure
    Module module;
    private EventList<ProxyUserDTO> eventList = new BasicEventList();
    @Uses
    private CommandQueryClient client;

    public EventList<ProxyUserDTO> getEventList() {
        return this.eventList;
    }

    @Override
    public void refresh() {
        ProxyUserListDTO proxyUsers = (ProxyUserListDTO)this.client.query("index", ProxyUserListDTO.class);
        EventListSynch.synchronize((Collection)proxyUsers.users().get(), this.eventList);
    }

    public void createProxyUser(NewProxyUserDTO proxyUserDTO) {
        try {
            this.client.postCommand("createproxyuser", (Object)proxyUserDTO);
        }
        catch (ResourceException e) {
            ErrorResources resources = ErrorResources.valueOf((String)e.getMessage());
            throw new OperationException((Enum)resources, (Throwable)e);
        }
    }

    public void changeEnabled(ProxyUserDTO proxyUser, boolean enabled) {
        Form form = new Form();
        form.set("enabled", Boolean.toString(enabled));
        this.client.getSubClient((String)proxyUser.username().get()).postCommand("changeenabled", (Object)form.getWebRepresentation());
    }

    public void resetPassword(ProxyUserDTO proxyUser, String password) {
        Form form = new Form();
        form.set("password", password);
        this.client.getSubClient((String)proxyUser.username().get()).postCommand("resetpassword", (Object)form);
    }

    public void remove(ProxyUserDTO proxyUser) {
        this.client.getSubClient((String)proxyUser.username().get()).delete();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.refresh();
    }
}

