/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.object.ObjectBuilderFactory;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.api.administration.form.RequiredSignatureValue;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationView;
import se.streamsource.streamflow.client.ui.administration.surface.AccessPointModel;
import se.streamsource.streamflow.client.ui.administration.surface.ReplacementSelectionFieldValuesView;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkValueConverter;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class AccessPointView
extends JPanel
implements Refreshable,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    @Structure
    ObjectBuilderFactory obf;
    private CaseLabelsView labels;
    private JLabel selectedCaseType = new JLabel();
    private StreamflowButton caseTypeButton;
    private StreamflowButton labelButton;
    private StreamflowButton projectButton;
    private JLabel selectedProject = new JLabel();
    private StreamflowButton formButton;
    private StreamflowButton replaceSelectionFieldValueEditButton;
    private JLabel selectedForm = new JLabel();
    private JLabel mailSelectionLabel = new JLabel();
    private JTextField mailSelectionField = new JTextField();
    private StreamflowButton templateButton;
    private RemovableLabel selectedTemplate = new RemovableLabel();
    private JCheckBox signActive1;
    private JTextField signName1;
    private JTextField signDescription1;
    private JCheckBox signActive2;
    private JTextField signName2;
    private JTextField signDescription2;
    private StreamflowButton form2Button;
    private JLabel selectedForm2;
    private JCheckBox mandatory2;
    private JTextField formQuestion2;
    private JList emailTemplateList = new JList();
    private JTextArea emailTemplateText = new JTextArea();
    private JTextField subject;
    private JTextField cookieExpiration = new JTextField();
    private AccessPointModel model;
    private ActionBinder actionBinder;
    private ValueBinder valueBinder;

    public AccessPointView(@Service ApplicationContext appContext, final @Uses AccessPointModel model, @Structure Module module) {
        this.model = model;
        this.labels = (CaseLabelsView)module.objectBuilderFactory().newObjectBuilder(CaseLabelsView.class).use(new Object[]{model.getLabelsModel()}).newInstance();
        this.setLayout(new BorderLayout());
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        RefreshComponents refreshComponents = new RefreshComponents();
        model.addObserver(refreshComponents);
        this.actionBinder = (ActionBinder)module.objectBuilderFactory().newObjectBuilder(ActionBinder.class).use(new Object[]{this.getActionMap()}).newInstance();
        this.valueBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.actionBinder.setResourceMap(appContext.getResourceMap(this.getClass()));
        LinkValueConverter linkValueConverter = new LinkValueConverter();
        FormLayout layout = new FormLayout("90dlu, 5dlu, 150:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 12dlu, pref, 2dlu, pref, 12dlu, pref, 2dlu, default:grow");
        JPanel panel = new JPanel((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
        builder.setBorder(Borders.createEmptyBorder((ConstantSize)Sizes.DLUY8, (ConstantSize)Sizes.DLUX4, (ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX8));
        CellConstraints cc = new CellConstraints();
        MacOsUIWrapper.convertAccelerators((ActionMap)appContext.getActionMap(AccessPointView.class, (Object)this));
        this.selectedProject.setFont(this.selectedProject.getFont().deriveFont(1));
        this.selectedCaseType.setFont(this.selectedCaseType.getFont().deriveFont(1));
        this.selectedForm.setFont(this.selectedForm.getFont().deriveFont(1));
        this.selectedTemplate.getLabel().setFont(this.selectedTemplate.getLabel().getFont().deriveFont(1));
        ActionMap am = this.getActionMap();
        javax.swing.Action projectAction = am.get("project");
        this.projectButton = new StreamflowButton(projectAction);
        this.projectButton.registerKeyboardAction(projectAction, (KeyStroke)projectAction.getValue("AcceleratorKey"), 2);
        this.projectButton.setHorizontalAlignment(2);
        builder.add((Component)this.projectButton, cc.xy(1, 1));
        builder.add((Component)this.valueBinder.bind("project", this.selectedProject, linkValueConverter), new CellConstraints(3, 1, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(5, 0, 0, 0)));
        javax.swing.Action caseTypeAction = am.get("casetype");
        this.caseTypeButton = new StreamflowButton(caseTypeAction);
        this.caseTypeButton.registerKeyboardAction(caseTypeAction, (KeyStroke)caseTypeAction.getValue("AcceleratorKey"), 2);
        this.caseTypeButton.setHorizontalAlignment(2);
        builder.add((Component)this.caseTypeButton, cc.xy(1, 3));
        builder.add((Component)this.valueBinder.bind("caseType", this.selectedCaseType, linkValueConverter), new CellConstraints(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(5, 0, 0, 0)));
        javax.swing.Action labelAction = this.labels.getActionMap().get("addLabel");
        this.labelButton = new StreamflowButton(labelAction);
        this.labelButton.registerKeyboardAction(labelAction, (KeyStroke)labelAction.getValue("AcceleratorKey"), 2);
        this.labelButton.setHorizontalAlignment(2);
        builder.add((Component)this.labelButton, cc.xy(1, 5, CellConstraints.FILL, CellConstraints.TOP));
        this.labels.setPreferredSize(new Dimension(500, 60));
        this.labels.setTextBold(true);
        this.labels.setButtonRelation(this.labelButton);
        builder.add((Component)this.labels, new CellConstraints(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(5, 0, 0, 0)));
        javax.swing.Action formAction = am.get("form");
        this.formButton = new StreamflowButton(formAction);
        this.formButton.registerKeyboardAction(formAction, (KeyStroke)formAction.getValue("AcceleratorKey"), 2);
        this.formButton.setHorizontalAlignment(2);
        builder.add((Component)this.formButton, cc.xy(1, 7, CellConstraints.FILL, CellConstraints.TOP));
        javax.swing.Action replaceSelectionFieldValueAction = am.get("openReplaceSelectionFieldValueEditor");
        this.replaceSelectionFieldValueEditButton = new StreamflowButton(replaceSelectionFieldValueAction);
        this.replaceSelectionFieldValueEditButton.setHorizontalAlignment(4);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("150dlu,5dlu,250:grow", "pref"));
        panelBuilder.add((Component)this.valueBinder.bind("form", this.selectedForm, linkValueConverter));
        panelBuilder.nextColumn(2);
        panelBuilder.add((Component)this.replaceSelectionFieldValueEditButton, new CellConstraints(3, 1, 1, 1, CellConstraints.RIGHT, CellConstraints.CENTER, new Insets(0, 0, 0, 0)));
        builder.add((Component)panelBuilder.getPanel(), new CellConstraints(3, 7, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(5, 0, 0, 0)));
        javax.swing.Action templateAction = am.get("template");
        this.templateButton = new StreamflowButton(templateAction);
        this.templateButton.registerKeyboardAction(templateAction, (KeyStroke)templateAction.getValue("AcceleratorKey"), 2);
        this.templateButton.setHorizontalAlignment(2);
        builder.add((Component)this.templateButton, cc.xy(1, 9, CellConstraints.FILL, CellConstraints.TOP));
        builder.add((Component)this.valueBinder.bind("template", this.actionBinder.bind("removeTemplate", this.selectedTemplate)), new CellConstraints(3, 9, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(3, 0, 0, 0)));
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.cookieExpirationHours, new Object[0])), cc.xy(1, 13, CellConstraints.LEFT, CellConstraints.BOTTOM));
        this.cookieExpiration = new JTextField();
        builder.add((Component)this.valueBinder.bind("cookieExpirationHours", this.actionBinder.bind("changeCookieExpirationHours", this.cookieExpiration)), new CellConstraints(3, 13, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(3, 0, 0, 0)));
        this.mailSelectionLabel.setText(i18n.text(AdministrationResources.changeMailSelectionMessage, new Object[0]));
        this.mailSelectionLabel.setToolTipText(i18n.text(AdministrationResources.changeMailSelectionMessageHint, new Object[0]));
        builder.add((Component)this.mailSelectionLabel, cc.xy(1, 15, CellConstraints.LEFT, CellConstraints.BOTTOM));
        builder.add((Component)this.valueBinder.bind("mailSelectionMessage", this.actionBinder.bind("changeMailSelectionMessage", this.mailSelectionField)), new CellConstraints(3, 15, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(3, 0, 0, 0)));
        PanelBuilder signPanel = new PanelBuilder(new FormLayout("180dlu, 15dlu, 180dlu", "default:grow"));
        CellConstraints signPanelCc = new CellConstraints();
        PanelBuilder primarySignPanel = new PanelBuilder(new FormLayout("180dlu", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, default:grow"));
        CellConstraints primaryCc = new CellConstraints();
        primarySignPanel.addSeparator(i18n.text(AdministrationResources.signature_1, new Object[0]), primaryCc.xy(1, 1));
        this.signActive1 = new JCheckBox(i18n.text(AdministrationResources.active, new Object[0]));
        primarySignPanel.add((Component)this.valueBinder.bind("primarysign", this.actionBinder.bind("setSignActive1", this.signActive1), new ValueBinder.Converter<RequiredSignatureValue, Boolean>(){

            @Override
            public Boolean toComponent(RequiredSignatureValue value) {
                return value != null ? (Boolean)value.active().get() : Boolean.FALSE;
            }
        }), primaryCc.xy(1, 3));
        primarySignPanel.addLabel(i18n.text(AdministrationResources.name_label, new Object[0]), primaryCc.xy(1, 5));
        this.signName1 = new JTextField();
        primarySignPanel.add((Component)this.valueBinder.bind("primarysign", this.actionBinder.bind("setSignName1", this.signName1), new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.name().get() : "";
            }
        }), primaryCc.xy(1, 7));
        refreshComponents.enabledOn("updateprimarysign", this.signName1);
        primarySignPanel.add((Component)new JLabel(i18n.text(AdministrationResources.description_label, new Object[0])), primaryCc.xy(1, 9));
        this.signDescription1 = new JTextField();
        primarySignPanel.add((Component)this.valueBinder.bind("primarysign", this.actionBinder.bind("setSignDescription1", this.signDescription1), new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.description().get() : "";
            }
        }), primaryCc.xy(1, 11));
        refreshComponents.enabledOn("updateprimarysign", this.signDescription1);
        signPanel.add((Component)primarySignPanel.getPanel(), signPanelCc.xy(1, 1, CellConstraints.LEFT, CellConstraints.TOP));
        PanelBuilder secondarySignPanel = new PanelBuilder(new FormLayout("180dlu", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 12dlu, pref, 2dlu, pref, 2dlu, default:grow"));
        CellConstraints secondaryCc = new CellConstraints();
        secondarySignPanel.addSeparator(i18n.text(AdministrationResources.signature_2, new Object[0]), secondaryCc.xy(1, 1));
        PanelBuilder secondaryOptionsPanel = new PanelBuilder(new FormLayout("70dlu,5dlu,70dlu,pref:grow", "pref"));
        this.signActive2 = new JCheckBox(i18n.text(AdministrationResources.active, new Object[0]));
        secondaryOptionsPanel.add((Component)this.valueBinder.bind("secondarysign", this.actionBinder.bind("setSignActive2", this.signActive2), new ValueBinder.Converter<RequiredSignatureValue, Boolean>(){

            @Override
            public Boolean toComponent(RequiredSignatureValue value) {
                return value != null ? (Boolean)value.active().get() : Boolean.FALSE;
            }
        }), secondaryCc.xy(1, 1));
        refreshComponents.enabledOn("updatesecondarysignactive", this.signActive2);
        this.mandatory2 = new JCheckBox(i18n.text(AdministrationResources.mandatory, new Object[0]));
        secondaryOptionsPanel.add((Component)this.valueBinder.bind("secondarysign", this.actionBinder.bind("setSecondMandatory", this.mandatory2), new ValueBinder.Converter<RequiredSignatureValue, Boolean>(){

            @Override
            public Boolean toComponent(RequiredSignatureValue value) {
                return value != null ? (Boolean)value.mandatory().get() : Boolean.FALSE;
            }
        }), secondaryCc.xy(3, 1));
        refreshComponents.enabledOn("updatesecondarysign", this.mandatory2);
        secondarySignPanel.add((Component)secondaryOptionsPanel.getPanel(), secondaryCc.xy(1, 3));
        secondarySignPanel.add((Component)new JLabel(i18n.text(AdministrationResources.name_label, new Object[0])), secondaryCc.xy(1, 5));
        this.signName2 = new JTextField();
        secondarySignPanel.add((Component)this.valueBinder.bind("secondarysign", this.actionBinder.bind("setSignName2", this.signName2), new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.name().get() : "";
            }
        }), secondaryCc.xy(1, 7));
        refreshComponents.enabledOn("updatesecondarysign", this.signName2);
        secondarySignPanel.add((Component)new JLabel(i18n.text(AdministrationResources.description_label, new Object[0])), secondaryCc.xy(1, 9));
        this.signDescription2 = new JTextField();
        secondarySignPanel.add((Component)this.valueBinder.bind("secondarysign", this.actionBinder.bind("setSignDescription2", this.signDescription2), new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.description().get() : "";
            }
        }), secondaryCc.xy(1, 11));
        refreshComponents.enabledOn("updatesecondarysign", this.signDescription2);
        javax.swing.Action form2Action = am.get("setSecondForm");
        this.form2Button = new StreamflowButton(form2Action);
        this.form2Button.registerKeyboardAction(form2Action, (KeyStroke)form2Action.getValue("AcceleratorKey"), 2);
        this.form2Button.setHorizontalAlignment(2);
        refreshComponents.enabledOn("updatesecondarysign", this.form2Button);
        PanelBuilder form2ButtonPanel = new PanelBuilder(new FormLayout("70dlu, 5dlu, 150dlu:grow", "pref"));
        CellConstraints form2ButtonPanelCc = new CellConstraints();
        form2ButtonPanel.add((Component)this.form2Button, form2ButtonPanelCc.xy(1, 1, CellConstraints.FILL, CellConstraints.TOP));
        this.selectedForm2 = new JLabel();
        form2ButtonPanel.add((Component)this.valueBinder.bind("secondarysign", this.selectedForm2, new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.formdescription().get() : "";
            }
        }), form2ButtonPanelCc.xy(3, 1, CellConstraints.LEFT, CellConstraints.CENTER));
        secondarySignPanel.add((Component)form2ButtonPanel.getPanel(), secondaryCc.xy(1, 13));
        secondarySignPanel.add((Component)new JLabel(i18n.text(AdministrationResources.question_label, new Object[0])), secondaryCc.xy(1, 17));
        this.formQuestion2 = new JTextField();
        secondarySignPanel.add((Component)this.valueBinder.bind("secondarysign", this.actionBinder.bind("setQuestion", this.formQuestion2), new ValueBinder.Converter<RequiredSignatureValue, String>(){

            @Override
            public String toComponent(RequiredSignatureValue value) {
                return value != null ? (String)value.question().get() : "";
            }
        }), secondaryCc.xy(1, 19));
        refreshComponents.enabledOn("updatesecondarysign", this.formQuestion2);
        signPanel.add((Component)secondarySignPanel.getPanel(), signPanelCc.xy(3, 1, CellConstraints.LEFT, CellConstraints.TOP));
        builder.add((Component)signPanel.getPanel(), new CellConstraints(1, 17, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JPanel templatePanel = new JPanel();
        templatePanel.setVisible(false);
        FormLayout templateFormLayout = new FormLayout("75dlu, 5dlu, fill:p:grow", "pref, pref, fill:p:grow, pref");
        DefaultFormBuilder templateFormBuilder = new DefaultFormBuilder(templateFormLayout, templatePanel);
        templateFormBuilder.addSeparator(i18n.text(AdministrationResources.emailTemplates, new Object[0]));
        templateFormBuilder.nextLine();
        this.subject = new JTextField();
        templateFormBuilder.append(i18n.text(AdministrationResources.subject, new Object[0]), (Component)this.valueBinder.bind("subject", this.actionBinder.bind("changeSubject", this.subject)));
        templateFormBuilder.nextLine();
        templateFormBuilder.append((Component)new JScrollPane(this.emailTemplateList));
        templateFormBuilder.append((Component)new JScrollPane(this.actionBinder.bind("save", this.emailTemplateText)));
        templateFormBuilder.nextLine();
        this.emailTemplateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && AccessPointView.this.emailTemplateList.getSelectedIndex() != -1) {
                    AccessPointView.this.emailTemplateText.setText((String)((Map)model.getAccessPointValue().messages().get()).get(AccessPointView.this.emailTemplateList.getSelectedValue()));
                }
            }
        });
        refreshComponents.visibleOn("updatesecondarysign", templatePanel);
        builder.add((Component)templatePanel, new CellConstraints(1, 19, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.add((Component)new JScrollPane(panel), "Center");
        new RefreshWhenShowing(this, this);
    }

    @Action
    public Task project() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleProjects()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.projectButton, dialog, i18n.text(WorkspaceResources.choose_project, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    AccessPointView.this.model.changeProject(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task casetype() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{i18n.text(WorkspaceResources.choose_casetype, new Object[0]), this.model.getPossibleCaseTypes()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.caseTypeButton, dialog);
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    AccessPointView.this.model.changeCaseType(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task form() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleForms()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.formButton, dialog, i18n.text(WorkspaceResources.choose_form, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    AccessPointView.this.model.changeForm(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task template() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleTemplates()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.templateButton, dialog, i18n.text(WorkspaceResources.choose_template, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    AccessPointView.this.model.setTemplate(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task removeTemplate() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setTemplate(null);
            }
        };
    }

    @Action
    public Task changeMailSelectionMessage() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                AccessPointView.this.model.changeMailSelectionMessage(AccessPointView.this.mailSelectionField.getText());
            }
        };
    }

    @Action
    public Task setSignActive1() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignActive1(AccessPointView.this.signActive1.isSelected());
            }
        };
    }

    @Action
    public Task setSignName1() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignName1(AccessPointView.this.signName1.getText());
            }
        };
    }

    @Action
    public Task setSignDescription1() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignDescription1(AccessPointView.this.signDescription1.getText());
            }
        };
    }

    @Action
    public Task setSignActive2() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignActive2(AccessPointView.this.signActive2.isSelected());
            }
        };
    }

    @Action
    public Task setSignName2() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignName2(AccessPointView.this.signName2.getText());
            }
        };
    }

    @Action
    public Task setSignDescription2() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSignDescription2(AccessPointView.this.signDescription2.getText());
            }
        };
    }

    @Action
    public Task setSecondForm() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleSecondForms()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.form2Button, dialog, i18n.text(WorkspaceResources.choose_form, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    AccessPointView.this.model.changeSecondForm(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task setSecondMandatory() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setSecondMandatory(AccessPointView.this.mandatory2.isSelected());
            }
        };
    }

    @Action
    public Task setQuestion() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.setQuestion(AccessPointView.this.formQuestion2.getText());
            }
        };
    }

    @Action
    public void openReplaceSelectionFieldValueEditor() {
        ReplacementSelectionFieldValuesView view = (ReplacementSelectionFieldValuesView)this.obf.newObjectBuilder(ReplacementSelectionFieldValuesView.class).use(new Object[]{this.model.getReplacementSelectionFieldValuesModel()}).newInstance();
        AdministrationView adminView = (AdministrationView)SwingUtilities.getAncestorOfClass(AdministrationView.class, this);
        adminView.show(view);
    }

    @Action
    public Task changeCookieExpirationHours() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                if (Strings.empty((String)AccessPointView.this.cookieExpiration.getText())) {
                    AccessPointView.this.model.changeCookieExpirationHours(null);
                } else {
                    AccessPointView.this.model.changeCookieExpirationHours(new Integer(AccessPointView.this.cookieExpiration.getText()));
                }
            }
        };
    }

    private void updateEnabled() {
        if (this.model.getAccessPointValue().project().get() == null) {
            this.caseTypeButton.setEnabled(false);
            this.labelButton.setEnabled(false);
            this.formButton.setEnabled(false);
        } else if (this.model.getAccessPointValue().caseType().get() == null) {
            this.caseTypeButton.setEnabled(true);
            this.labelButton.setEnabled(false);
            this.formButton.setEnabled(false);
        } else {
            this.caseTypeButton.setEnabled(true);
            this.labelButton.setEnabled(true);
            this.formButton.setEnabled(true);
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedLabel", "removedLabel", "addedCaseType", "addedProject", "addedSelectedForm", "changedProject", "changedCaseType", "formPdfTemplateSet", "changedMailSelectionMessage", "createdRequiredSignature", "updatedRequiredSignature", "changedCookieExpirationHours"}), transactions)) {
            this.refresh();
        }
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.valueBinder.update((ValueComposite)this.model.getAccessPointValue());
        int selectedIndex = this.emailTemplateList.getSelectedIndex();
        DefaultListModel<String> emailTemplateListModel = new DefaultListModel<String>();
        for (String key : ((Map)this.model.getAccessPointValue().messages().get()).keySet()) {
            emailTemplateListModel.addElement(key);
        }
        this.emailTemplateList.setModel(emailTemplateListModel);
        this.emailTemplateList.setSelectedIndex(selectedIndex);
        this.replaceSelectionFieldValueEditButton.setIcon((Boolean)this.model.getAccessPointValue().replacementValues().get() != false ? i18n.icon(Icons.optionsok, 16) : i18n.icon(Icons.options, 16));
    }

    @Action
    public Task changeSubject() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.changeSubject(AccessPointView.this.subject.getText());
            }
        };
    }

    @Action
    public Task save() {
        final String template = this.emailTemplateText.getText();
        final String key = (String)this.emailTemplateList.getSelectedValue();
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                AccessPointView.this.model.updateTemplate(key, template);
                ((Map)AccessPointView.this.model.getAccessPointValue().messages().get()).put(key, template);
            }
        };
    }
}

