/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.roles;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.roles.RolesModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class RolesView
extends JPanel
implements TransactionListener {
    RolesModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JList roleList;

    public RolesView(@Service ApplicationContext context, @Uses RolesModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.roleList = new JList(new EventListModel(model.getList()));
        this.roleList.setCellRenderer(new LinkListCellRenderer());
        this.add((Component)this.roleList, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.getActionMap().get("add")));
        toolbar.add(new StreamflowButton(this.getActionMap().get("remove")));
        this.add((Component)toolbar, "South");
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_role_title, new Object[0]));
        final String name = dialog.name();
        if (!Strings.empty((String)name)) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    RolesView.this.model.create(name);
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.roleList.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    RolesView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
    }
}

