/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.resolutions;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.resolutions.ResolutionsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.SeparatorListCellRenderer;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.TitledLinkGroupingComparator;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class ResolutionsView
extends JPanel
implements TransactionListener {
    ResolutionsModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JList list;

    public ResolutionsView(@Service ApplicationContext context, @Uses ResolutionsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        JPopupMenu options = new JPopupMenu();
        options.add(am.get("rename"));
        options.add(am.get("showUsages"));
        options.add(am.get("remove"));
        JScrollPane scrollPane = new JScrollPane();
        EventList<LinkValue> itemValueEventList = model.getList();
        this.list = new JList(new EventListModel(itemValueEventList));
        this.list.setCellRenderer(new LinkListCellRenderer());
        scrollPane.setViewportView(this.list);
        this.add((Component)scrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(new OptionsAction(options)));
        this.add((Component)toolbar, "South");
        this.list.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove"), am.get("rename"), am.get("showUsages")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_resolution_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ResolutionsView.this.model.create(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ResolutionsView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action
    public void showUsages() {
        LinkValue item = (LinkValue)this.list.getSelectedValue();
        SeparatorList separatorList = new SeparatorList(this.model.usages(item), (Comparator)new TitledLinkGroupingComparator(), 1, 10000);
        JList<Object> list = new JList<Object>();
        list.setCellRenderer(new SeparatorListCellRenderer(new LinkListCellRenderer()));
        list.setModel((ListModel<Object>)new EventListModel((EventList)separatorList));
        this.dialogs.showOkDialog(this, list);
        separatorList.dispose();
    }

    @Action
    public Task rename() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog);
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ResolutionsView.this.model.changeDescription((LinkValue)ResolutionsView.this.list.getSelectedValue(), dialog.name());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
    }
}

