/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.projectsettings;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.administration.RequiresCaseTypeDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.projectsettings.RequiresCaseTypeModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class RequiresCaseTypeView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private RequiresCaseTypeModel model;
    private JCheckBox requiresCaseType = new JCheckBox("Aktiv");
    private DefaultFormBuilder builder;

    public RequiresCaseTypeView(@Service ApplicationContext context, @Uses RequiresCaseTypeModel model) {
        this.model = model;
        model.addObserver(this);
        FormLayout layout = new FormLayout("150dlu, 2dlu, 50, 200", "pref");
        this.setLayout((LayoutManager)layout);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.builder.add((Component)new JLabel(i18n.text(AdministrationResources.change_requires_case_type, new Object[0])), new CellConstraints(1, 1));
        this.builder.add((Component)this.requiresCaseType, new CellConstraints(3, 1, 2, 1));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        new ActionBinder((ActionMap)am).bind("changeRequiresCaseType", this.requiresCaseType);
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        RequiresCaseTypeDTO settings = (RequiresCaseTypeDTO)this.model.getIndex();
        this.requiresCaseType.setSelected((Boolean)settings.requiresCaseType().get());
    }

    @Action
    public void changeRequiresCaseType() {
        this.model.changeRequiresCaseType(this.requiresCaseType.isSelected());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedRequiresCaseType"}), transactions)) {
            this.model.refresh();
        }
    }
}

