/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.projects;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.projects.ProjectsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.TabbedResourceView;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class ProjectsView
extends ListDetailView {
    ProjectsModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public ProjectsView(@Service ApplicationContext context, final @Uses ProjectsModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("add"), new javax.swing.Action[]{am.get("rename"), am.get("remove")}, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                TabbedResourceView view = (TabbedResourceView)ProjectsView.this.module.objectBuilderFactory().newObjectBuilder(TabbedResourceView.class).use(new Object[]{model.newResourceModel(detailLink)}).newInstance();
                return view;
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_project_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProjectsView.this.model.create(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProjectsView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action
    public Task rename() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.change_project_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ProjectsView.this.model.changeDescription(selected, dialog.name());
                }
            };
        }
        return null;
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"removedProject"}), transactions)) {
            super.notifyTransactions(transactions);
        }
    }
}

