/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.priorities;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.priorities.PrioritiesModel;
import se.streamsource.streamflow.client.ui.administration.priorities.PriorityView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class PrioritiesView
extends ListDetailView
implements TransactionListener {
    private PrioritiesModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public PrioritiesView(@Service ApplicationContext context, final @Uses PrioritiesModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getUnsortedList()), am.get("add"), new javax.swing.Action[]{am.get("remove"), am.get("up"), am.get("down")}, true, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                return (Component)PrioritiesView.this.module.objectBuilderFactory().newObjectBuilder(PriorityView.class).use(new Object[]{model.newResourceModel(detailLink)}).newInstance();
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_casepriority_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    PrioritiesView.this.model.create(dialog.name());
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task remove() {
        final LinkValue selected = this.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    PrioritiesView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task up() {
        final LinkValue selected = this.getSelectedValue();
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PrioritiesView.this.model.up(selected);
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task down() {
        final LinkValue selected = this.getSelectedValue();
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PrioritiesView.this.model.down(selected);
            }
        };
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        LinkValue oldSelection = this.getSelectedValue();
        super.notifyTransactions(transactions);
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdPriority", "changedDescription", "changedPriority", "removedPriority"}), transactions)) {
            this.model.refresh();
            if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdPriority"}), transactions)) {
                this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
            } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedDescription", "changedPriority"}), transactions)) {
                int count = 0;
                for (LinkValue link : this.model.getUnsortedList()) {
                    if (((String)link.id().get()).equals(oldSelection.id().get())) {
                        this.list.setSelectedIndex(count);
                        return;
                    }
                    ++count;
                }
            } else if (Events.matches((Specification)Events.withNames((String[])new String[]{"removedPriority"}), transactions)) {
                this.list.clearSelection();
            }
        }
    }
}

