/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.organisationsettings;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.organisationsettings.MailRestrictionsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class MailRestrictionsView
extends JPanel
implements TransactionListener {
    MailRestrictionsModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JList list;
    private DefaultFormBuilder builder;

    public MailRestrictionsView(@Service ApplicationContext context, @Uses MailRestrictionsModel model) {
        this.model = model;
        FormLayout layout = new FormLayout("150dlu, 2dlu, 50, 200", "pref");
        this.setLayout((LayoutManager)layout);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.builder.add((Component)new JLabel(i18n.text(AdministrationResources.mailrestrictions_addresses, new Object[0])), new CellConstraints(1, 1, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(4, 0, 0, 0)));
        JPanel addressPanel = new JPanel(new BorderLayout());
        addressPanel.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        JPopupMenu options = new JPopupMenu();
        options.add(am.get("rename"));
        options.add(am.get("remove"));
        JScrollPane scrollPane = new JScrollPane();
        EventList<LinkValue> itemValueEventList = model.getList();
        this.list = new JList(new EventListModel(itemValueEventList));
        this.list.setCellRenderer(new LinkListCellRenderer());
        scrollPane.setViewportView(this.list);
        addressPanel.add((Component)scrollPane, "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(new OptionsAction(options)));
        addressPanel.add((Component)toolbar, "South");
        this.list.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove"), am.get("rename")));
        this.builder.add((Component)addressPanel, new CellConstraints(3, 1, 2, 1));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_mailrestriction_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    MailRestrictionsView.this.model.create(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    MailRestrictionsView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action
    public Task rename() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog);
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    MailRestrictionsView.this.model.changeDescription((LinkValue)MailRestrictionsView.this.list.getSelectedValue(), dialog.name());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
    }
}

