/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.util.Iterables;
import org.restlet.data.Form;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.form.VisibilityRuleDefinitionValue;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public class VisibilityRuleValuesModel
implements Refreshable {
    @Uses
    CommandQueryClient client;
    private EventList<String> elements = new BasicEventList();

    public EventList<String> getEventList() {
        return this.elements;
    }

    @Override
    public void refresh() {
        VisibilityRuleDefinitionValue visibilityRuleDefinitionValue = (VisibilityRuleDefinitionValue)this.client.query("rule", VisibilityRuleDefinitionValue.class);
        EventListSynch.synchronize((Collection)visibilityRuleDefinitionValue.values().get(), this.elements);
    }

    public void addElement(String name) {
        Form form = new Form();
        form.set("value", name);
        this.client.postCommand("addrulevalue", (Object)form.getWebRepresentation());
    }

    public void addElements(LinksValue selectedLinks) {
        for (LinkValue link : (List)selectedLinks.links().get()) {
            Form form = new Form();
            form.set("value", (String)link.text().get());
            this.client.postCommand("addrulevalue", (Object)form.getWebRepresentation());
        }
    }

    public void removeElement(int index) {
        Form form = new Form();
        form.set("index", Integer.toString(index));
        this.client.postCommand("removerulevalue", (Object)form.getWebRepresentation());
    }

    public void changeElementName(String newName, int index) {
        Form form = new Form();
        form.set("value", newName);
        form.set("index", Integer.toString(index));
        this.client.postCommand("changerulevaluename", (Object)form.getWebRepresentation());
    }

    public EventList<LinkValue> possiblePredefinedRuleValues() {
        BasicEventList possibleRuleValues = new BasicEventList();
        LinksValue available = (LinksValue)this.client.query("possiblerulevalues", LinksValue.class);
        ArrayList linkValues = new ArrayList();
        CollectionUtils.addAll(linkValues, Iterables.filter((Specification)new Specification<LinkValue>(){

            public boolean satisfiedBy(LinkValue link) {
                return !VisibilityRuleValuesModel.this.elements.contains(link.text().get());
            }
        }, (Iterable)((Iterable)available.links().get())).iterator());
        EventListSynch.synchronize(linkValues, possibleRuleValues);
        return possibleRuleValues;
    }
}

