/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXRadioGroup;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.form.PageDefinitionValue;
import se.streamsource.streamflow.api.administration.form.VisibilityRuleCondition;
import se.streamsource.streamflow.api.administration.form.VisibilityRuleDefinitionValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.PageEditModel;
import se.streamsource.streamflow.client.ui.administration.forms.definition.VisibilityRuleValuesView;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class PageEditView
extends JScrollPane
implements Refreshable,
TransactionListener {
    private ValueBinder valueBinder;
    private ActionBinder actionBinder;
    private RefreshComponents refreshComponents;
    private PageEditModel model;
    private JTextField descriptionField = new JTextField();
    private JComboBox ruleFieldIdCombo = new JComboBox();
    private JComboBox ruleConditionCombo = new JComboBox();
    private JXRadioGroup buttonGroup;
    private JRadioButton visibleWhenTrue;
    private JRadioButton visibleWhenFalse;

    public PageEditView(@Service ApplicationContext context, @Uses PageEditModel model, @Structure Module module) {
        this.model = model;
        JPanel panel = new JPanel(new BorderLayout());
        this.refreshComponents = new RefreshComponents();
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.valueBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.actionBinder = (ActionBinder)module.objectBuilderFactory().newObjectBuilder(ActionBinder.class).use(new Object[]{context.getActionMap((Object)this)}).newInstance();
        this.actionBinder.setResourceMap(context.getResourceMap(this.getClass()));
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel fieldPanel = new JPanel();
        FormLayout fieldFormLayout = new FormLayout("45dlu, 5dlu, 150dlu:grow", "pref, pref");
        DefaultFormBuilder fieldFormBuilder = new DefaultFormBuilder(fieldFormLayout, fieldPanel);
        fieldFormBuilder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        fieldFormBuilder.append(i18n.text(AdministrationResources.type_label, new Object[0]), (Component)new JLabel(i18n.text(AdministrationResources.page_break_field_type, new Object[0])));
        fieldFormBuilder.nextLine();
        fieldFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.name_label, new Object[0])));
        fieldFormBuilder.nextColumn(2);
        fieldFormBuilder.add((Component)this.valueBinder.bind("description", this.actionBinder.bind("changeDescription", this.descriptionField)));
        topPanel.add((Component)fieldPanel, "North");
        JPanel rulePanel = new JPanel();
        FormLayout ruleFormLayout = new FormLayout("45dlu, 5dlu, 150dlu, 5dlu, 45dlu, 5dlu, 150dlu:grow", "pref, pref, pref, pref:grow");
        DefaultFormBuilder ruleFormBuilder = new DefaultFormBuilder(ruleFormLayout, rulePanel);
        ruleFormBuilder.addSeparator(i18n.text(AdministrationResources.visibility_rule, new Object[0]));
        ruleFormBuilder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        ruleFormBuilder.nextLine();
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_field_id, new Object[0])));
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)this.valueBinder.bind("fieldId", this.actionBinder.bind("changeRuleFieldId", this.ruleFieldIdCombo)));
        this.ruleFieldIdCombo.setRenderer(new LinkListCellRenderer());
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_values, new Object[0])));
        VisibilityRuleValuesView visibilityRuleValuesView = (VisibilityRuleValuesView)module.objectBuilderFactory().newObjectBuilder(VisibilityRuleValuesView.class).use(new Object[]{model.newVisibilityRuleValuesModel()}).newInstance();
        ruleFormBuilder.add((Component)visibilityRuleValuesView, new CellConstraints(7, 2, 1, 3, CellConstraints.FILL, CellConstraints.FILL));
        ruleFormBuilder.nextLine();
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_condition, new Object[0])));
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)this.valueBinder.bind("condition", this.actionBinder.bind("changeRuleCondition", this.ruleConditionCombo)));
        this.ruleConditionCombo.setRenderer(new DefaultListRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof LinkValue) {
                    LinkValue itemValue = (LinkValue)value;
                    String val = itemValue == null ? "" : i18n.text((Enum)VisibilityRuleCondition.valueOf((String)((String)itemValue.text().get())), new Object[0]);
                    return super.getListCellRendererComponent(list, (Object)val, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_visible_when, new Object[0])), new CellConstraints(1, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP));
        javax.swing.Action visibilityWhenToTrueAction = am.get("changeVisibleWhenToTrue");
        javax.swing.Action visibilityWhenToFalseAction = am.get("changeVisibleWhenToFalse");
        this.buttonGroup = new JXRadioGroup();
        this.buttonGroup.setLayoutAxis(2);
        this.visibleWhenTrue = new JRadioButton(visibilityWhenToTrueAction);
        this.visibleWhenFalse = new JRadioButton(visibilityWhenToFalseAction);
        this.buttonGroup.add((Component)this.visibleWhenTrue);
        this.buttonGroup.add((Component)this.visibleWhenFalse);
        ruleFormBuilder.add((Component)this.buttonGroup, new CellConstraints(3, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP));
        topPanel.add((Component)rulePanel, "Center");
        panel.add((Component)topPanel, "North");
        panel.add((Component)new JPanel(), "Center");
        this.refreshComponents.visibleOn("possiblerulefields", rulePanel);
        this.setViewportView(panel);
        new RefreshWhenShowing(this, this);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeDescription() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                PageEditView.this.model.changeDescription(PageEditView.this.descriptionField.getText());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeRuleFieldId() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PageEditView.this.model.changeRuleFieldId((LinkValue)PageEditView.this.ruleFieldIdCombo.getSelectedItem());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeRuleCondition() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PageEditView.this.model.changeRuleCondition((LinkValue)PageEditView.this.ruleConditionCombo.getSelectedItem());
            }
        };
    }

    @Action
    public Task changeVisibleWhenToTrue() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PageEditView.this.model.changeRuleVisibleWhen(true);
            }
        };
    }

    @Action
    public Task changeVisibleWhenToFalse() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PageEditView.this.model.changeRuleVisibleWhen(false);
            }
        };
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.valueBinder.update((ValueComposite)this.model.getIndex());
        this.valueBinder.update((ValueComposite)((PageDefinitionValue)this.model.getIndex()).rule().get());
        if (this.model.query("possiblerulefields") != null) {
            EventList<LinkValue> eventList = this.model.possibleRuleFields();
            this.ruleFieldIdCombo.setModel(new EventComboBoxModel(eventList));
            this.ruleFieldIdCombo.setSelectedItem(this.findLinkValueWithId(eventList, (String)((VisibilityRuleDefinitionValue)((PageDefinitionValue)this.model.getIndex()).rule().get()).field().get()));
            EventList<LinkValue> eventList2 = this.model.possibleRuleConditions();
            this.ruleConditionCombo.setModel(new EventComboBoxModel(eventList2));
            this.ruleConditionCombo.setSelectedItem(this.findLinkValueWithId(eventList2, ((VisibilityRuleCondition)((VisibilityRuleDefinitionValue)((PageDefinitionValue)this.model.getIndex()).rule().get()).condition().get()).name()));
            if (((Boolean)((VisibilityRuleDefinitionValue)((PageDefinitionValue)this.model.getIndex()).rule().get()).visibleWhen().get()).booleanValue()) {
                this.visibleWhenFalse.setSelected(false);
                this.visibleWhenTrue.setSelected(true);
            } else {
                this.visibleWhenFalse.setSelected(true);
                this.visibleWhenTrue.setSelected(false);
            }
        }
        this.refreshComponents.refresh(this.model.getResourceValue());
    }

    private LinkValue findLinkValueWithId(EventList<LinkValue> list, String id) {
        for (LinkValue link : list) {
            if (!((String)link.id().get()).equals(id)) continue;
            return link;
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedRule"}), transactions)) {
            this.refresh();
            this.revalidate();
        }
    }
}

