/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Comparator;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.FormView;
import se.streamsource.streamflow.client.ui.administration.forms.FormsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SeparatorListCellRenderer;
import se.streamsource.streamflow.client.util.TitledLinkGroupingComparator;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class FormsView
extends ListDetailView
implements TransactionListener {
    private FormsModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public FormsView(@Service ApplicationContext context, final @Uses FormsModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("add"), new javax.swing.Action[]{am.get("move"), am.get("showUsages"), am.get("remove")}, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                return (Component)FormsView.this.module.objectBuilderFactory().newObjectBuilder(FormView.class).use(new Object[]{model.newResourceModel(detailLink)}).newInstance();
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        NameDialog formDialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, formDialog, i18n.text(AdministrationResources.create_new_form, new Object[0]));
        final String name = formDialog.name();
        if (!Strings.empty((String)name)) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormsView.this.model.create(name);
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed() && selected != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormsView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action
    public Task move() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleMoveTo(selected)}).newInstance();
        dialog.setPreferredSize(new Dimension(200, 300));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_move_to, new Object[0]));
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormsView.this.model.moveForm(selected, dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public void showUsages() {
        LinkValue item = (LinkValue)this.list.getSelectedValue();
        SeparatorList separatorList = new SeparatorList(this.model.usages(item), (Comparator)new TitledLinkGroupingComparator(), 1, 10000);
        JList<Object> list = new JList<Object>();
        list.setCellRenderer(new SeparatorListCellRenderer(new LinkListCellRenderer()));
        list.setModel((ListModel<Object>)new EventListModel((EventList)separatorList));
        this.dialogs.showOkDialog(this, list);
        separatorList.dispose();
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        DomainEvent event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"createdForm"}), (Iterable)Events.events(transactions)));
        if (event != null) {
            String id = EventParameters.getParameter((DomainEvent)event, (int)1);
            for (LinkValue link : this.model.getUnsortedList()) {
                if (!((String)link.href().get()).endsWith(id + "/")) continue;
                this.list.setSelectedValue(link, true);
                break;
            }
        }
        super.notifyTransactions(transactions);
    }
}

