/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.filters;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.restlet.data.Form;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.filters.ActionsView;
import se.streamsource.streamflow.client.ui.administration.filters.FilterModel;
import se.streamsource.streamflow.client.ui.administration.filters.RulesView;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.BindingFormBuilder2;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.i18n;

public class FilterView
extends JPanel
implements Refreshable {
    private FilterModel model;
    private Module module;
    private ActionBinder actions;
    private ValueBinder values;
    protected JTextField nameField;
    protected JCheckBox enabled;
    protected JRadioButton all;
    protected JRadioButton any;
    protected DefaultFormBuilder formBuilder;
    protected RulesView rulesView;
    protected ActionsView actionsView;
    protected ButtonGroup matching;

    public FilterView(@Service ApplicationContext context, @Uses FilterModel model, @Structure Module module) {
        this.model = model;
        this.module = module;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        FormLayout layout = new FormLayout("100dlu, 2dlu, 200:grow", "pref, pref, pref, pref, 20dlu, pref, pref");
        this.setLayout((LayoutManager)layout);
        this.formBuilder = new DefaultFormBuilder(layout, (JPanel)this);
        this.actions = new ActionBinder((ActionMap)am);
        this.values = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        BindingFormBuilder2 binding = new BindingFormBuilder2(this.formBuilder, this.actions, this.values, context.getResourceMap(this.getClass()));
        this.nameField = new JTextField();
        binding.appendWithLabel(AdministrationResources.name_label, this.nameField, "name", "update", new Object[0]);
        this.enabled = new JCheckBox();
        binding.appendWithLabel(AdministrationResources.enabled, this.enabled, "enabled", "update", new Object[0]);
        this.all = new JRadioButton();
        this.all.setActionCommand("all");
        binding.appendWithLabel(AdministrationResources.all, this.all, "matching", "update", new Object[0]);
        this.any = new JRadioButton();
        this.any.setActionCommand("any");
        binding.appendWithLabel(AdministrationResources.any, this.any, "matching", "update", new Object[0]);
        this.matching = new ButtonGroup();
        this.matching.add(this.any);
        this.matching.add(this.all);
        this.formBuilder.nextLine();
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        if (this.rulesView == null) {
            this.formBuilder.appendSeparator(i18n.text(AdministrationResources.filter_rules, new Object[0]));
            this.rulesView = (RulesView)this.module.objectBuilderFactory().newObjectBuilder(RulesView.class).use(new Object[]{this.model.newResourceModel((LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)"rules"), (Iterable)((Iterable)this.model.getResourceValue().resources().get()))))}).newInstance();
            this.formBuilder.append((Component)this.rulesView, 3);
            this.formBuilder.appendSeparator(i18n.text(AdministrationResources.filter_actions, new Object[0]));
            this.actionsView = (ActionsView)this.module.objectBuilderFactory().newObjectBuilder(ActionsView.class).use(new Object[]{this.model.newResourceModel((LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)"actions"), (Iterable)((Iterable)this.model.getResourceValue().resources().get()))))}).newInstance();
            this.formBuilder.append((Component)this.actionsView, 3);
            this.revalidate();
        }
        this.values.update(this.model.getIndex());
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task update() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                Form form = FilterView.this.model.getIndex();
                form.set("name", FilterView.this.nameField.getText());
                form.set("enabled", FilterView.this.enabled.isSelected() + "");
                form.set("matching", FilterView.this.matching.getSelection().getActionCommand());
                FilterView.this.model.update(form);
            }
        };
    }
}

