/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.filters;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.PopupAction;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.filters.ActionsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ActionsView
extends JPanel
implements TransactionListener {
    @Service
    private DialogService dialogs;
    @Structure
    private Module module;
    private ActionsModel model;
    public JList list;

    public ActionsView(@Service ApplicationContext context, @Structure Module module, @Uses ActionsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        JScrollPane scrollPane = new JScrollPane();
        EventList<LinkValue> itemValueEventList = model.getUnsortedList();
        this.list = new JList(new EventListModel(itemValueEventList));
        scrollPane.setViewportView(this.list);
        this.add((Component)scrollPane, "Center");
        JPopupMenu addPopup = new JPopupMenu();
        addPopup.add(am.get("addEmail"));
        addPopup.add(am.get("addEmailNotification"));
        addPopup.add(am.get("addClose"));
        PopupAction popupAction = new PopupAction(addPopup, i18n.text(AdministrationResources.add_filter_action, new Object[0]), i18n.icon(Icons.add, 16));
        JPopupMenu options = new JPopupMenu();
        options.add(am.get("remove"));
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(popupAction));
        toolbar.add(new StreamflowButton(new OptionsAction(options)));
        this.add((Component)toolbar, "South");
        this.list.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof LinkValue) {
                    LinkValue itemValue = (LinkValue)value;
                    String val = "";
                    if (itemValue != null) {
                        if ("closeaction".equals(itemValue.rel().get())) {
                            val = i18n.text(AdministrationResources.close_case, new Object[0]);
                        } else if ("emailaction".equals(itemValue.rel().get())) {
                            val = i18n.text(AdministrationResources.send_email_to, itemValue.text().get());
                        } else if ("emailnotificationaction".equals(itemValue.rel().get())) {
                            val = i18n.text(AdministrationResources.send_email_notification_to, itemValue.text().get());
                        }
                    }
                    return super.getListCellRendererComponent((JList<?>)list, val, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task addEmail() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleRecipients()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_recipient_title, new Object[0]));
        if (dialog.getSelectedLinks() != null && dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ActionsView.this.model.createEmailAction(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public Task addEmailNotification() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleNotificationRecipients()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_recipient_title, new Object[0]));
        if (dialog.getSelectedLinks() != null && dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ActionsView.this.model.createEmailNotificationAction(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public Task addClose() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(AdministrationResources.add_filter_close_action_confirmation, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    ActionsView.this.model.closeCaseAction();
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        final LinkValue linkValue = (LinkValue)((List)((LinksValue)this.model.getIndex()).links().get()).get(this.list.getSelectedIndex());
        if ("emailaction".equals(linkValue.rel().get())) {
            dialog.setCustomMessage(i18n.text(AdministrationResources.remove_action_confirmation, i18n.text(AdministrationResources.send_email_to, linkValue.text().get())));
        } else if ("emailnotificationaction".equals(linkValue.rel().get())) {
            dialog.setCustomMessage(i18n.text(AdministrationResources.remove_action_confirmation, i18n.text(AdministrationResources.send_email_notification_to, linkValue.text().get())));
        } else if ("closeaction".equals(linkValue.rel().get())) {
            dialog.setCustomMessage(i18n.text(AdministrationResources.remove_action_confirmation, i18n.text(AdministrationResources.close_case, new Object[0])));
        }
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    ActionsView.this.model.remove(linkValue);
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"updatedFilter"}), transactions)) {
            this.model.refresh();
        }
    }
}

