/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.casesettings;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.casesettings.CaseAccessDefaultsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class CaseAccessDefaultsView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private CaseAccessDefaultsModel model;
    private final ApplicationContext context;

    public CaseAccessDefaultsView(@Service ApplicationContext context, @Uses CaseAccessDefaultsModel model) {
        this.context = context;
        this.model = model;
        model.addObserver(this);
        this.setLayout(new BoxLayout(this, 1));
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.removeAll();
        LinksValue links = (LinksValue)this.model.getIndex();
        for (final LinkValue linkValue : (List)links.links().get()) {
            StreamflowButton comp = new StreamflowButton((String)linkValue.text().get());
            comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    final SelectLinkDialog dialog = (SelectLinkDialog)CaseAccessDefaultsView.this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{CaseAccessDefaultsView.this.model.getPossibleDefaultAccessTypes(linkValue)}).newInstance();
                    dialog.setPreferredSize(new Dimension(200, 100));
                    CaseAccessDefaultsView.this.dialogs.showOkCancelHelpDialog(CaseAccessDefaultsView.this, dialog, i18n.text(AdministrationResources.choose_default_access_type, new Object[0]));
                    if (dialog.getSelectedLink() != null) {
                        CaseAccessDefaultsView.this.context.getTaskService().execute((Task)new CommandTask(){

                            @Override
                            public void command() throws Exception {
                                CaseAccessDefaultsView.this.model.changeDefaultAccessType(dialog.getSelectedLink());
                            }
                        });
                    }
                }
            });
            this.add(comp);
        }
        this.revalidate();
        this.repaint();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.refresh();
    }
}

