/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.swing.EventTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultTreeRenderer;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.WrappingProvider;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.ui.administration.AdministrationModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.ResourceActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class AdministrationTreeView
extends JPanel
implements TransactionListener,
Refreshable {
    private JXTree tree;
    @Service
    DialogService dialogs;
    @Service
    StreamflowApplication application;
    private AdministrationModel model;
    @Structure
    Module module;

    public AdministrationTreeView(@Service ApplicationContext context, final @Uses AdministrationModel model) throws Exception {
        super(new BorderLayout());
        this.model = model;
        this.tree = new JXTree((TreeModel)new EventTreeModel(model.getLinkTree()));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setExpandsSelectedPaths(true);
        DefaultTreeRenderer renderer = new DefaultTreeRenderer((ComponentProvider)new WrappingProvider(new IconValue(){

            public Icon getIcon(Object o) {
                if (o instanceof TreeList.Node) {
                    TreeList.Node node = (TreeList.Node)o;
                    LinkValue link = (LinkValue)node.getElement();
                    String rel = (String)link.rel().get();
                    return i18n.icon(Icons.valueOf(rel));
                }
                return null;
            }
        }, new StringValue(){

            public String getString(Object o) {
                if (o instanceof TreeList.Node) {
                    TreeList.Node node = (TreeList.Node)o;
                    LinkValue link = (LinkValue)node.getElement();
                    return (String)link.text().get();
                }
                return o.toString();
            }
        }, false));
        this.tree.setCellRenderer((TreeCellRenderer)renderer);
        JPanel toolbar = new JPanel();
        toolbar.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)new JScrollPane((Component)this.tree), "Center");
        ApplicationActionMap am = context.getActionMap((Object)this);
        JPopupMenu adminPopup = new JPopupMenu();
        adminPopup.add(am.get("changeDescription"));
        adminPopup.add(am.get("delete"));
        adminPopup.add(new JSeparator());
        adminPopup.add(am.get("move"));
        adminPopup.add(am.get("merge"));
        JPanel actions = new JPanel();
        StreamflowButton createOUButton = new StreamflowButton(am.get("create"));
        createOUButton.setEnabled(false);
        actions.add(createOUButton);
        StreamflowButton optionsButton = new StreamflowButton(new OptionsAction(adminPopup));
        actions.add(optionsButton);
        this.add((Component)actions, "South");
        new RefreshWhenShowing(this, model);
        ResourceActionEnabler resourceActionEnabler = new ResourceActionEnabler(new javax.swing.Action[]{am.get("changeDescription"), am.get("delete"), am.get("move"), am.get("merge"), am.get("create")}){

            @Override
            protected ResourceValue getResource() {
                if (AdministrationTreeView.this.tree.getSelectionPath() == null) {
                    return null;
                }
                ResourceModel resourceModel = (ResourceModel)model.newResourceModel((LinkValue)((TreeList.Node)AdministrationTreeView.this.tree.getSelectionPath().getLastPathComponent()).getElement());
                resourceModel.refresh();
                return resourceModel.getResourceValue();
            }
        };
        new RefreshWhenShowing(adminPopup, resourceActionEnabler);
        this.tree.addTreeSelectionListener(new TreeSelectionListener((ActionMap)am, optionsButton, resourceActionEnabler){
            final /* synthetic */ ActionMap val$am;
            final /* synthetic */ StreamflowButton val$optionsButton;
            final /* synthetic */ ResourceActionEnabler val$resourceActionEnabler;
            {
                this.val$am = actionMap;
                this.val$optionsButton = streamflowButton;
                this.val$resourceActionEnabler = resourceActionEnabler;
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (AdministrationTreeView.this.tree.isSelectionEmpty()) {
                    this.val$am.get("create").setEnabled(false);
                    this.val$optionsButton.setEnabled(false);
                } else {
                    this.val$optionsButton.setEnabled(true);
                    this.val$resourceActionEnabler.refresh();
                }
            }
        });
        new RefreshWhenShowing(this, this);
    }

    public JTree getTree() {
        return this.tree;
    }

    @Action
    public Task changeDescription() {
        final Object node = this.tree.getSelectionPath().getLastPathComponent();
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.change_ou_title, new Object[0]));
        if (!Strings.empty((String)dialog.name()) && node instanceof TreeList.Node) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    AdministrationTreeView.this.model.changeDescription(node, dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task create() {
        final LinkValue node = (LinkValue)((TreeList.Node)this.tree.getSelectionPath().getLastPathComponent()).getElement();
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.create_ou_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    AdministrationTreeView.this.model.createOrganizationalUnit(node, dialog.name().trim());
                }
            };
        }
        return null;
    }

    @Action
    public Task delete() {
        final Object node = this.tree.getSelectionPath().getLastPathComponent();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        TreeList.Node treeNode = (TreeList.Node)node;
        String name = (String)((LinkValue)treeNode.getElement()).text().get();
        dialog.setRemovalMessage(name);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    AdministrationTreeView.this.model.removeOrganizationalUnit(node);
                }
            };
        }
        return null;
    }

    @Action
    public Task move() {
        EventList<LinkValue> targets = this.model.possibleMoveTo(this.tree.getSelectionPath().getLastPathComponent());
        final SelectLinkDialog listDialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{targets}).newInstance();
        this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), listDialog, i18n.text(AdministrationResources.move_to, new Object[0]));
        if (listDialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    AdministrationTreeView.this.model.move(AdministrationTreeView.this.tree.getSelectionPath().getLastPathComponent(), listDialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public Task merge() {
        EventList<LinkValue> targets = this.model.possibleMergeWith(this.tree.getSelectionPath().getLastPathComponent());
        final SelectLinkDialog listDialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{targets}).newInstance();
        this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), listDialog, i18n.text(AdministrationResources.merge_to, new Object[0]));
        if (listDialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    AdministrationTreeView.this.model.move(AdministrationTreeView.this.tree.getSelectionPath().getLastPathComponent(), listDialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Specifications.and((Specification[])new Specification[]{Events.onEntityTypes((String[])new String[]{"se.streamsource.streamflow.web.domain.entity.organization.OrganizationEntity", "se.streamsource.streamflow.web.domain.entity.organization.OrganizationalUnitEntity"}), Events.withNames((String[])new String[]{"changedDescription", "removedOrganizationalUnit", "addedOrganizationalUnit"})}), transactions)) {
            ArrayList<Integer> expandedRows = new ArrayList<Integer>();
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                if (!this.tree.isExpanded(i)) continue;
                expandedRows.add(i);
            }
            int[] selected = this.tree.getSelectionRows();
            this.model.notifyTransactions(transactions);
            this.tree.setModel((TreeModel)new EventTreeModel(this.model.getLinkTree()));
            for (Integer expandedRow : expandedRows) {
                this.tree.expandRow(expandedRow.intValue());
            }
            this.tree.setSelectionRows(selected);
        }
    }

    @Override
    public void refresh() {
        this.tree.expandRow(0);
    }
}

