/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.account.ProfileModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class ProfileView
extends JScrollPane
implements TransactionListener,
Refreshable {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private ProfileModel model;
    private ValueBinder profileBinder;
    private ValueBinder phoneNumberBinder;
    private ValueBinder emailBinder;
    private ActionBinder actionBinder;
    private JPanel profileForm;
    private JRadioButton noneButton;
    private JRadioButton emailButton;
    private JTextField name;
    private JTextField emailAddress;
    private JTextField phoneNumber;
    private JTextField markReadTimeout;
    private JTextArea mailFooter;

    public ProfileView(@Service ApplicationContext context, @Uses ProfileModel model, @Structure Module module) {
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.model = model;
        this.actionBinder = (ActionBinder)module.objectBuilderFactory().newObjectBuilder(ActionBinder.class).use(new Object[]{am}).newInstance();
        this.actionBinder.setResourceMap(context.getResourceMap(this.getClass()));
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.profileForm = new JPanel();
        panel.add((Component)this.profileForm, "Center");
        FormLayout profileLayout = new FormLayout("85dlu, 5dlu, 120dlu:grow", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref");
        this.profileBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.phoneNumberBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.emailBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        DefaultFormBuilder profileBuilder = new DefaultFormBuilder(profileLayout, this.profileForm);
        JLabel title = new JLabel(i18n.text(AccountResources.contact_info_for_user_separator, new Object[0]));
        title.setFont(title.getFont().deriveFont(1));
        profileBuilder.append((Component)title, 3);
        profileBuilder.nextLine();
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.name_label, new Object[0])));
        profileBuilder.nextColumn(2);
        this.name = new JTextField();
        profileBuilder.add((Component)this.profileBinder.bind("name", this.actionBinder.bind("changeName", this.name)));
        profileBuilder.nextLine();
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.email_label, new Object[0])));
        profileBuilder.nextColumn(2);
        this.emailAddress = new JTextField();
        profileBuilder.add((Component)this.emailBinder.bind("emailAddress", this.actionBinder.bind("changeEmailAddress", this.emailAddress)));
        profileBuilder.nextLine();
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.phone_label, new Object[0])));
        profileBuilder.nextColumn(2);
        this.phoneNumber = new JTextField();
        profileBuilder.add((Component)this.phoneNumberBinder.bind("phoneNumber", this.actionBinder.bind("changePhoneNumber", this.phoneNumber)));
        profileBuilder.nextLine(2);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.choose_message_delivery_type, new Object[0])));
        profileBuilder.nextColumn(2);
        this.noneButton = new JRadioButton();
        profileBuilder.add((Component)this.profileBinder.bind("messageDeliveryType", this.actionBinder.bind("messageDeliveryTypeNone", this.noneButton)));
        profileBuilder.nextLine();
        profileBuilder.nextColumn(2);
        this.emailButton = new JRadioButton();
        profileBuilder.add((Component)this.profileBinder.bind("messageDeliveryType", this.actionBinder.bind("messageDeliveryTypeEmail", this.emailButton)));
        this.noneButton.setAction(am.get((Object)"messageDeliveryTypeNone"));
        this.emailButton.setAction(am.get((Object)"messageDeliveryTypeEmail"));
        this.noneButton.setActionCommand("none");
        this.emailButton.setActionCommand("email");
        ButtonGroup group = new ButtonGroup();
        group.add(this.noneButton);
        group.add(this.emailButton);
        profileBuilder.nextLine(2);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.mark_read_timeout, new Object[0])));
        profileBuilder.nextColumn(2);
        this.markReadTimeout = new JTextField();
        profileBuilder.add((Component)this.profileBinder.bind("markReadTimeout", this.actionBinder.bind("changeMarkReadTimeout", this.markReadTimeout)));
        profileBuilder.nextLine(2);
        profileBuilder.add((Component)new JLabel(i18n.text(WorkspaceResources.mail_footer, new Object[0])));
        profileBuilder.nextColumn(2);
        this.mailFooter = new JTextArea(10, 30);
        profileBuilder.add((Component)this.profileBinder.bind("mailFooter", this.actionBinder.bind("changeMailFooter", this.mailFooter)));
        profileBuilder.nextLine();
        this.setViewportView(panel);
        new RefreshWhenShowing(this, this);
    }

    @Action
    public Task messageDeliveryTypeNone() throws Exception {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeMessageDeliveryType("none");
            }
        };
    }

    @Action
    public Task messageDeliveryTypeEmail() throws Exception {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeMessageDeliveryType("email");
            }
        };
    }

    @Action
    public Task changeName() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeName(ProfileView.this.name.getText());
            }
        };
    }

    @Action
    public Task changeEmailAddress() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeEmailAddress(ProfileView.this.emailAddress.getText());
            }
        };
    }

    @Action
    public Task changePhoneNumber() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changePhoneNumber(ProfileView.this.phoneNumber.getText());
            }
        };
    }

    @Action
    public Task changeMarkReadTimeout() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeMarkReadTimeout(ProfileView.this.markReadTimeout.getText());
            }
        };
    }

    @Action
    public Task changeMailFooter() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                ProfileView.this.model.changeMailFooter(ProfileView.this.mailFooter.getText());
            }
        };
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.profileBinder.update((ValueComposite)this.model.getIndex());
        this.emailBinder.update((ValueComposite)this.model.getEmailAddress());
        this.phoneNumberBinder.update((ValueComposite)this.model.getPhoneNumber());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedTimeout", "updatedContact", "changedMessageDeliveryType", "changedDescription", "changedMailFooter"}), transactions)) {
            this.refresh();
        }
    }
}

