/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class FormEditor {
    Component[] components;
    boolean editing = false;

    public FormEditor(Component ... components) {
        this.components = components;
        this.init(components);
        this.view();
    }

    private void init(Component ... components) {
        for (Component component : components) {
            if (component instanceof JPanel) {
                this.init(((JPanel)component).getComponents());
                continue;
            }
            if (component instanceof JLabel) {
                final JLabel label = (JLabel)component;
                label.addPropertyChangeListener("text", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        FormEditor.this.setVisible(label, evt.getNewValue() != null && !evt.getNewValue().equals(""));
                    }
                });
                continue;
            }
            if (!(component instanceof JTextComponent)) continue;
            final JTextComponent text = (JTextComponent)component;
            text.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    if (!FormEditor.this.isEditing()) {
                        if (text.getText().equals("")) {
                            FormEditor.this.setVisible(text, false);
                        } else if (!text.isVisible()) {
                            FormEditor.this.setVisible(text, true);
                        }
                    }
                }
            });
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void view() {
        this.editing = false;
        this.view(this.components);
    }

    private void view(Component ... components) {
        for (Component component : components) {
            if (component instanceof JPanel) {
                this.view(((JPanel)component).getComponents());
            } else if (!(component instanceof JLabel) && component instanceof JComponent) {
                JComponent text = (JComponent)component;
                text.setEnabled(false);
            }
            component.doLayout();
        }
    }

    public void edit() {
        this.editing = true;
        this.edit(this.components);
    }

    private void edit(Component ... components) {
        for (Component component : components) {
            if (component instanceof JPanel) {
                this.edit(((JPanel)component).getComponents());
                continue;
            }
            if (component instanceof JLabel || !(component instanceof JComponent)) continue;
            JComponent text = (JComponent)component;
            text.setEnabled(true);
            this.setVisible(component, true);
        }
    }

    private void setVisible(Component component, boolean b) {
        component.setVisible(b);
        JLabel label = (JLabel)((JComponent)component).getClientProperty("labeledBy");
        if (label != null) {
            label.setVisible(b);
        }
    }
}

