/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.EventListModel;
import info.aduna.io.IOUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.account.AccountsModel;
import se.streamsource.streamflow.client.ui.account.VetoableListSelectionModel;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class AccountSelector
extends JList
implements ListEventListener,
VetoableChangeListener {
    private AccountsModel dataModel;
    private ApplicationContext context;
    @Service
    private DialogService dialogs;
    @Service
    private StreamflowApplication main;

    public AccountSelector(@Uses AccountsModel dataModel) {
        super(new EventListModel(dataModel.getAccounts()));
        this.dataModel = dataModel;
        this.context = Application.getInstance().getContext();
        this.setCellRenderer(new LinkListCellRenderer());
        dataModel.getAccounts().addListEventListener((ListEventListener)this);
        VetoableListSelectionModel veto = new VetoableListSelectionModel();
        this.setSelectionModel(veto);
        this.setSelectionMode(0);
        veto.addVetoableChangeListener(this);
    }

    public AccountModel getSelectedAccount() {
        return this.getSelectedIndex() == -1 ? null : this.dataModel.accountModel((LinkValue)this.getSelectedValue());
    }

    public void listChanged(ListEvent listEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AccountSelector.this.isSelectionEmpty() && AccountSelector.this.dataModel.getAccounts().size() == 1) {
                    AccountSelector.this.setSelectedIndex(0);
                }
            }
        });
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        try {
            if (evt.getNewValue() != null && (Integer)evt.getNewValue() != -1) {
                InputStream is = this.getClass().getResourceAsStream("/version.properties");
                Properties p = IOUtil.readProperties((InputStream)is);
                String clientVersion = p.getProperty("application.version");
                if (clientVersion.startsWith("$")) {
                    return;
                }
                String response = this.dataModel.accountModel((LinkValue)this.getModel().getElementAt((Integer)evt.getNewValue())).test();
                System.out.print(response);
                if (response != null) {
                    String str;
                    BufferedReader reader = new BufferedReader(new StringReader(response));
                    while ((str = reader.readLine()) != null) {
                        int toIndex;
                        if ((str = str.trim()).startsWith("Variant:")) {
                            if (!Locale.getDefault().equals(new Locale("sv", "SE"))) continue;
                            Locale.setDefault(new Locale("sv", "SE", str.substring(str.indexOf(":") + 1, str.length()).trim()));
                            continue;
                        }
                        if (!str.startsWith("Version:")) continue;
                        int n = toIndex = str.indexOf(45) != -1 ? str.indexOf(45) : str.lastIndexOf(46);
                        if (toIndex == -1) {
                            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
                        }
                        String serverVersion = str.substring(str.indexOf(":") + 1, toIndex);
                        if (clientVersion.startsWith(serverVersion.trim())) continue;
                        String msg = MessageFormat.format(i18n.text(AccountResources.version_missmatch, new Object[0]), clientVersion, serverVersion);
                        this.dialogs.showMessageDialog(this, msg, "Info");
                        throw new PropertyVetoException(msg, evt);
                    }
                }
            }
        }
        catch (ResourceException e) {
            String msg = Status.CLIENT_ERROR_UNAUTHORIZED.equals((Object)e.getStatus()) ? i18n.text((Enum)ErrorResources.unauthorized_access, new Object[0]) : i18n.text(AccountResources.resource_failure, new Object[0]) + " \r\n" + e.getStatus().toString();
            this.dialogs.showMessageDialog(this, msg, "Info");
            this.main.manageAccounts();
            throw new PropertyVetoException(msg, evt);
        }
        catch (IOException e) {
            String msg = i18n.text(AccountResources.cannot_read_stream, new Object[0]);
            this.dialogs.showMessageDialog(this, msg, "Info");
            throw new PropertyVetoException(msg, evt);
        }
    }
}

