/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui;

import java.util.List;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Application;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.Uniform;
import org.restlet.resource.ClientResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.domain.individual.Account;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.domain.individual.Individual;
import se.streamsource.streamflow.client.domain.individual.IndividualRepository;

@Mixins(value={Mixin.class})
public interface DummyDataService
extends ServiceComposite,
Activatable {

    public static class Mixin
    implements Activatable {
        final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
        @Structure
        Module module;
        @Service
        IndividualRepository individualRepository;
        @Service
        Uniform client;
        @Structure
        Application app;

        public void activate() throws Exception {
            try {
                UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork(UsecaseBuilder.newUsecase((String)"Create account"));
                Individual individual = this.individualRepository.individual();
                ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(AccountSettingsValue.class);
                ((AccountSettingsValue)builder.prototype()).name().set((Object)"Test server administrator");
                ((AccountSettingsValue)builder.prototype()).server().set((Object)"http://localhost:8040/streamflow");
                ((AccountSettingsValue)builder.prototype()).userName().set((Object)"administrator");
                ((AccountSettingsValue)builder.prototype()).password().set((Object)"administrator");
                Account account = individual.newAccount((AccountSettingsValue)builder.newInstance());
                ((AccountSettingsValue)builder.prototype()).name().set((Object)"Test server someuser");
                ((AccountSettingsValue)builder.prototype()).userName().set((Object)"someuser");
                ((AccountSettingsValue)builder.prototype()).password().set((Object)"someuser");
                individual.newAccount((AccountSettingsValue)builder.newInstance());
                CommandQueryClient server = account.server(this.client);
                ClientResource version = new ClientResource(server.getReference().clone().addSegment("static").addSegment("version.html"));
                version.setNext(this.client);
                String response = account.version(this.client);
                System.out.println(response);
                CommandQueryClient user = account.server(this.client).getSubClient("users").getSubClient("administrator");
                System.out.println(((List)((LinksValue)user.getSubClient("workspace").getSubClient("user").getSubClient("drafts").query("index", LinksValue.class)).links().get()).size());
                uow.complete();
            }
            catch (Exception e) {
                this.logger.warn("Could not create dummy account");
                e.printStackTrace();
            }
        }

        public void passivate() throws Exception {
        }
    }
}

