/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.swingx.JXFrame;
import org.jdesktop.swingx.JXTable;
import org.qi4j.api.injection.scope.Service;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class DebugWindow
extends FrameView {
    public EventTable eventTable = new EventTable();

    public DebugWindow(@Service Application application) {
        super(application);
        this.eventTable.setEditable(false);
        JXFrame frame = new JXFrame("Streamflow Debug");
        frame.getContentPane().add(new JScrollPane((Component)((Object)this.eventTable)));
        this.setFrame((JFrame)frame);
        JToolBar toolbar = new JToolBar();
        ApplicationActionMap am = application.getContext().getActionMap((Object)this);
        toolbar.add(am.get("clear"));
        this.setToolBar(toolbar);
        frame.setPreferredSize(new Dimension(600, 300));
        frame.pack();
    }

    @Action
    public void clear() {
        this.eventTable.clear();
    }

    public static class EventTable
    extends JXTable
    implements TransactionListener {
        private DefaultTableModel eventModel = new DefaultTableModel(new String[]{"Usecase", "Event", "Entity", "Parameters"}, 0);

        public EventTable() {
            this.setModel(this.eventModel);
        }

        public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
            for (DomainEvent event : Events.events(transactions)) {
                this.eventModel.addRow(new String[]{(String)event.usecase().get(), (String)event.name().get(), (String)event.entity().get(), (String)event.parameters().get()});
                if (this.eventModel.getRowCount() <= 100) continue;
                this.eventModel.removeRow(0);
            }
        }

        public void clear() {
            int count = this.eventModel.getRowCount();
            for (int i = 0; i < count; ++i) {
                this.eventModel.removeRow(0);
            }
        }
    }
}

