/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import org.joda.time.DateTime;
import se.streamsource.streamflow.client.ui.DateFormatsResources;
import se.streamsource.streamflow.util.Dates;

public class DateFormats {
    private static SimpleDateFormat formatTime = new SimpleDateFormat("HH:mm");
    private static SimpleDateFormat formatDay = new SimpleDateFormat("d MMM");

    public static String getProgressiveDateTimeValue(Calendar calendar, Locale locale) {
        if (calendar == null) {
            return "";
        }
        if (Dates.isToday((Calendar)calendar)) {
            return formatTime.format(calendar.getTime());
        }
        if (Dates.isThisYear((Calendar)calendar)) {
            return formatDay.format(calendar.getTime());
        }
        return new SimpleDateFormat(DateFormats.getBundle(locale).getString(DateFormatsResources.date.toString())).format(calendar.getTime());
    }

    public static String getProgressiveDateTimeValue(Date date, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateFormats.getProgressiveDateTimeValue(calendar, locale);
    }

    public static String getFullDateTimeValue(Date date, Locale locale) {
        return new SimpleDateFormat(DateFormats.getBundle(locale).getString(DateFormatsResources.full_datetime.toString())).format(date);
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(DateFormatsResources.class.getName(), locale);
    }

    public static String getProgressiveDateTimeValue(DateTime date, Locale locale) {
        return DateFormats.getProgressiveDateTimeValue(date.toDate(), locale);
    }
}

