/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.infrastructure.configuration;

import java.io.File;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.usecase.UsecaseBuilder;
import org.qi4j.entitystore.jdbm.JdbmConfiguration;
import se.streamsource.streamflow.infrastructure.configuration.FileConfiguration;

@Mixins(value={ServiceConfigurationMixin.class})
public interface ServiceConfiguration
extends ServiceComposite,
Activatable {

    public static class ServiceConfigurationMixin
    implements Activatable {
        @Service
        FileConfiguration config;
        @Structure
        Module module;

        public void activate() throws Exception {
            UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork(UsecaseBuilder.newUsecase((String)"Service configuration"));
            String jdbmPath = new File(this.config.dataDirectory(), "jdbm.data").getAbsolutePath();
            EntityBuilder jdbm = uow.newEntityBuilder(JdbmConfiguration.class, "JdbmEntityStoreService");
            ((JdbmConfiguration)jdbm.instance()).file().set((Object)jdbmPath);
            jdbm.newInstance();
            uow.complete();
        }

        public void passivate() throws Exception {
        }
    }
}

