/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.assembler;

import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.LayerAssembly;
import se.streamsource.streamflow.client.assembler.DomainAssembler;
import se.streamsource.streamflow.client.assembler.InfrastructureAssembler;
import se.streamsource.streamflow.client.assembler.ModelAssembler;
import se.streamsource.streamflow.client.assembler.RESTAssembler;

public class StreamflowClientModelAssembler
implements ApplicationAssembler {
    Object[] serviceObjects;

    public StreamflowClientModelAssembler(Object ... serviceObjects) {
        this.serviceObjects = serviceObjects;
    }

    public ApplicationAssembly assemble(ApplicationAssemblyFactory applicationFactory) throws AssemblyException {
        ApplicationAssembly assembly = applicationFactory.newApplicationAssembly();
        assembly.setName("StreamflowClient");
        assembly.setVersion("0.1");
        LayerAssembly domainInfrastructureLayer = assembly.layer("Client domain infrastructure");
        LayerAssembly domainLayer = assembly.layer("Domain");
        LayerAssembly modelLayer = assembly.layer("Model");
        LayerAssembly restLayer = assembly.layer("REST");
        domainLayer.uses(new LayerAssembly[]{domainInfrastructureLayer, restLayer});
        modelLayer.uses(new LayerAssembly[]{domainLayer, domainInfrastructureLayer, restLayer});
        restLayer.uses(new LayerAssembly[]{domainInfrastructureLayer});
        new ModelAssembler().assemble(modelLayer);
        new DomainAssembler().assemble(domainLayer);
        new InfrastructureAssembler().assemble(domainInfrastructureLayer);
        new RESTAssembler().assembler(restLayer);
        for (Object serviceObject : this.serviceObjects) {
            assembly.setMetaInfo(serviceObject);
        }
        return assembly;
    }
}

