/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.assembler;

import org.qi4j.api.common.Visibility;
import org.qi4j.api.structure.Application;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.LayerAssembly;
import org.qi4j.bootstrap.ModuleAssembly;
import org.qi4j.entitystore.jdbm.JdbmConfiguration;
import org.qi4j.entitystore.jdbm.JdbmEntityStoreService;
import org.qi4j.entitystore.memory.MemoryEntityStoreService;
import org.qi4j.spi.uuid.UuidIdentityGeneratorService;
import se.streamsource.streamflow.client.infrastructure.configuration.ServiceConfiguration;
import se.streamsource.streamflow.client.infrastructure.events.ClientEventSourceService;
import se.streamsource.streamflow.infrastructure.configuration.FileConfiguration;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;

public class InfrastructureAssembler {
    public void assemble(LayerAssembly layer) throws AssemblyException {
        this.configuration(layer.module("Configuration"));
        this.clientEntityStyore(layer.module("Client EntityStore"));
        this.clientEvents(layer.module("Client Events"));
    }

    public void configuration(ModuleAssembly module) throws AssemblyException {
        System.setProperty("application", "StreamFlowClient");
        module.services(new Class[]{ServiceConfiguration.class}).instantiateOnStartup();
        module.services(new Class[]{FileConfiguration.class}).instantiateOnStartup().visibleIn(Visibility.application);
        module.entities(new Class[]{JdbmConfiguration.class}).visibleIn(Visibility.layer);
        module.services(new Class[]{MemoryEntityStoreService.class});
    }

    private void clientEntityStyore(ModuleAssembly module) throws AssemblyException {
        Application.Mode mode = module.layer().application().mode();
        if (mode.equals((Object)Application.Mode.development)) {
            module.services(new Class[]{MemoryEntityStoreService.class, UuidIdentityGeneratorService.class}).visibleIn(Visibility.application);
        } else if (mode.equals((Object)Application.Mode.test)) {
            module.services(new Class[]{MemoryEntityStoreService.class, UuidIdentityGeneratorService.class}).visibleIn(Visibility.application);
        } else if (mode.equals((Object)Application.Mode.production)) {
            module.services(new Class[]{JdbmEntityStoreService.class, UuidIdentityGeneratorService.class}).visibleIn(Visibility.application);
        }
    }

    private void clientEvents(ModuleAssembly module) throws AssemblyException {
        module.values(new Class[]{TransactionDomainEvents.class, DomainEvent.class}).visibleIn(Visibility.application);
        module.services(new Class[]{ClientEventSourceService.class}).visibleIn(Visibility.application);
    }
}

