/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.popup;

import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.ListSelectionListener;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.client.util.popup.ValueToLabelConverter;

public class SelectionList
extends JList {
    public SelectionList(List<String> values, final List<String> selected, final ValueToLabelConverter converter, ListSelectionListener listener) {
        super(values.toArray());
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setFont(list.getFont());
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                if (selected.contains(value)) {
                    this.setIcon(i18n.icon(Icons.check, 12));
                    this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                } else {
                    this.setIcon(null);
                    this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                }
                this.setText(converter.convert(value.toString()));
                return this;
            }
        });
        this.addListSelectionListener(listener);
    }
}

