/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.mapquest;

import java.io.IOException;
import java.util.Locale;
import org.qi4j.api.injection.scope.Uses;
import org.restlet.ext.jackson.JacksonConverter;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.resource.UniformResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.streamflow.client.util.mapquest.MapquestQueryResult;

public class MapquestNominatimService {
    private static final Logger logger = LoggerFactory.getLogger(MapquestNominatimService.class);
    private String mapquestReverseLookupUrlPattern;
    private JacksonConverter converter = new JacksonConverter();

    public MapquestNominatimService(@Uses String mapquestReverseLookupUrlPattern) {
        this.mapquestReverseLookupUrlPattern = mapquestReverseLookupUrlPattern;
    }

    public MapquestQueryResult reverseLookup(double latitude, double longitude) {
        String url = this.reverseLookupQueryUrl(latitude, longitude);
        logger.info("Reverse geo lookup for: " + url);
        MapquestQueryResult result = this.getObject(MapquestQueryResult.class, url);
        logger.info("Reverse geo result: " + result);
        return result;
    }

    private <T> T getObject(Class<T> clazz, String url) {
        Object result;
        ClientResource clientResource = new ClientResource(url);
        Representation response = clientResource.get();
        try {
            result = this.converter.toObject(response, clazz, (UniformResource)clientResource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private String reverseLookupQueryUrl(double latitude, double longitude) {
        return String.format(Locale.US, this.mapquestReverseLookupUrlPattern, latitude, longitude);
    }

    public static void main(String[] args) {
        new MapquestNominatimService("http://open.mapquestapi.com/nominatim/v1/reverse?lat=%f&lon=%f&format=json").reverseLookup(55.681, 12.577);
    }
}

