/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.TransactionList;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.casetypes.CaseTypesView;
import se.streamsource.streamflow.client.ui.administration.casetypes.RemovedCaseTypesView;
import se.streamsource.streamflow.client.ui.administration.casetypes.SelectedCaseTypesView;
import se.streamsource.streamflow.client.ui.administration.external.IntegrationPointsView;
import se.streamsource.streamflow.client.ui.administration.filters.FiltersView;
import se.streamsource.streamflow.client.ui.administration.forms.FormsView;
import se.streamsource.streamflow.client.ui.administration.forms.SelectedFormsView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FormEditView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FormElementsView;
import se.streamsource.streamflow.client.ui.administration.groups.GroupsView;
import se.streamsource.streamflow.client.ui.administration.labels.LabelsView;
import se.streamsource.streamflow.client.ui.administration.labels.SelectedLabelsView;
import se.streamsource.streamflow.client.ui.administration.policy.AdministratorsView;
import se.streamsource.streamflow.client.ui.administration.priorities.PrioritiesView;
import se.streamsource.streamflow.client.ui.administration.projects.MembersView;
import se.streamsource.streamflow.client.ui.administration.projects.ProjectsView;
import se.streamsource.streamflow.client.ui.administration.resolutions.ResolutionsView;
import se.streamsource.streamflow.client.ui.administration.resolutions.SelectedResolutionsView;
import se.streamsource.streamflow.client.ui.administration.surface.AccessPointsView;
import se.streamsource.streamflow.client.ui.administration.surface.EmailAccessPointsView;
import se.streamsource.streamflow.client.ui.administration.surface.ProxyUsersView;
import se.streamsource.streamflow.client.ui.administration.templates.TemplatesView;
import se.streamsource.streamflow.client.ui.administration.users.UsersAdministrationListView;
import se.streamsource.streamflow.client.util.SettingsResourceView;
import se.streamsource.streamflow.client.util.i18n;

public class TabbedResourceView
extends JTabbedPane {
    private static final Map<String, Class<? extends JComponent>> views = new LinkedHashMap<String, Class<? extends JComponent>>();
    private static final Map<String, Enum> tabNames = new LinkedHashMap<String, Enum>();

    private static void addTab(String name, Enum tabName, Class<? extends JComponent> viewClass) {
        tabNames.put(name, tabName);
        views.put(name, viewClass);
    }

    public TabbedResourceView(@Uses ResourceModel model, @Structure Module module) {
        this.setTabLayoutPolicy(0);
        model.refresh();
        TransactionList<LinkValue> resources = model.getResources();
        int index = 0;
        for (Map.Entry<String, Class<? extends JComponent>> stringClassEntry : views.entrySet()) {
            LinkValue linkedResource = (LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)stringClassEntry.getKey()), resources));
            if (linkedResource == null) continue;
            String tabNameText = i18n.text(tabNames.get(stringClassEntry.getKey()), new Object[0]);
            Class<? extends JComponent> tabClass = stringClassEntry.getValue();
            try {
                Object resourceModel = model.newResourceModel(linkedResource);
                this.addTab(tabNameText, (Component)module.objectBuilderFactory().newObjectBuilder(tabClass).use(new Object[]{resourceModel}).newInstance());
                this.setMnemonicAt(index, 49 + index);
                ++index;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SettingsResourceView settings = new SettingsResourceView(model, module);
        if (settings.getComponentCount() > 1) {
            this.addTab(i18n.text(AdministrationResources.settings_tab, new Object[0]), settings);
        }
    }

    static {
        TabbedResourceView.addTab("members", AdministrationResources.members_tab, MembersView.class);
        TabbedResourceView.addTab("projects", AdministrationResources.projects_tab, ProjectsView.class);
        TabbedResourceView.addTab("groups", AdministrationResources.groups_tab, GroupsView.class);
        TabbedResourceView.addTab("forms", AdministrationResources.forms_tab, FormsView.class);
        TabbedResourceView.addTab("selectedforms", AdministrationResources.selected_forms_tab, SelectedFormsView.class);
        TabbedResourceView.addTab("casetypes", AdministrationResources.casetypes_tab, CaseTypesView.class);
        TabbedResourceView.addTab("selectedcasetypes", AdministrationResources.selected_casetypes_tab, SelectedCaseTypesView.class);
        TabbedResourceView.addTab("removedcasetypes", AdministrationResources.removed_casetypes_tab, RemovedCaseTypesView.class);
        TabbedResourceView.addTab("priorities", AdministrationResources.casepriorities_tab, PrioritiesView.class);
        TabbedResourceView.addTab("labels", AdministrationResources.labels_tab, LabelsView.class);
        TabbedResourceView.addTab("selectedlabels", AdministrationResources.selected_labels_tab, SelectedLabelsView.class);
        TabbedResourceView.addTab("resolutions", AdministrationResources.resolutions_tab, ResolutionsView.class);
        TabbedResourceView.addTab("selectedresolutions", AdministrationResources.selected_resolutions_tab, SelectedResolutionsView.class);
        TabbedResourceView.addTab("organizationusers", AdministrationResources.users_tab, UsersAdministrationListView.class);
        TabbedResourceView.addTab("filters", AdministrationResources.filters_tab, FiltersView.class);
        TabbedResourceView.addTab("accesspoints", AdministrationResources.accesspoints_tab, AccessPointsView.class);
        TabbedResourceView.addTab("emailaccesspoints", AdministrationResources.emailaccesspoints_tab, EmailAccessPointsView.class);
        TabbedResourceView.addTab("integrationpoints", AdministrationResources.integrationpoints_tab, IntegrationPointsView.class);
        TabbedResourceView.addTab("proxyusers", AdministrationResources.proxyusers_tab, ProxyUsersView.class);
        TabbedResourceView.addTab("templates", AdministrationResources.templates_tab, TemplatesView.class);
        TabbedResourceView.addTab("forminfo", AdministrationResources.forminfo_tab, FormEditView.class);
        TabbedResourceView.addTab("pages", AdministrationResources.formpages_tab, FormElementsView.class);
        TabbedResourceView.addTab("administrators", AdministrationResources.administrators_tab, AdministratorsView.class);
    }
}

