/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.color.EyeDropperColorChooserPanel;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.OS;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.i18n;

public class StreamflowJXColorSelectionButton
extends JButton {
    private BufferedImage colorwell;
    private JDialog dialog = null;
    private JColorChooser chooser = null;

    public StreamflowJXColorSelectionButton() {
        this(Color.black);
    }

    public StreamflowJXColorSelectionButton(Color col) {
        this.setBackground(col);
        this.addActionListener(new ActionHandler());
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                StreamflowJXColorSelectionButton.this.getChooser().setColor(StreamflowJXColorSelectionButton.this.getBackground());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Color FILL_COLOR;
        Color color = FILL_COLOR = this.isEnabled() ? ColorUtil.removeAlpha((Color)this.getBackground()) : UIManagerExt.getSafeColor((Object)"Button.disabledForeground", (Color)Color.LIGHT_GRAY);
        if (OS.isMacOSX() && this.colorwell != null) {
            Insets ins = new Insets(5, 5, 5, 5);
            ColorUtil.tileStretchPaint((Graphics)g, (JComponent)this, (BufferedImage)this.colorwell, (Insets)ins);
            g.setColor(FILL_COLOR);
            g.fillRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            g.setColor(ColorUtil.setBrightness((Color)FILL_COLOR, (float)0.85f));
            g.drawRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right - 1, this.getHeight() - ins.top - ins.bottom - 1);
            g.drawRect(ins.left + 1, ins.top + 1, this.getWidth() - ins.left - ins.right - 3, this.getHeight() - ins.top - ins.bottom - 3);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.LIGHT_GRAY);
                int DIAM = Math.min(this.getWidth(), this.getHeight());
                int inset = 3;
                g2.fill(new Ellipse2D.Float(3.0f, 3.0f, DIAM - 6, DIAM - 6));
                g2.setColor(FILL_COLOR);
                boolean border = true;
                g2.fill(new Ellipse2D.Float(4.0f, 4.0f, DIAM - 6 - 2, DIAM - 6 - 2));
            }
            finally {
                g2.dispose();
            }
        }
    }

    private void showDialog() {
        final Color oldColor = this.getBackground();
        if (this.dialog == null) {
            this.dialog = JColorChooser.createDialog(this, i18n.text(AdministrationResources.choose_color, new Object[0]), true, this.getChooser(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = StreamflowJXColorSelectionButton.this.getChooser().getColor();
                    if (color != null) {
                        StreamflowJXColorSelectionButton.this.setBackground(color);
                    }
                }
            }, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StreamflowJXColorSelectionButton.this.setBackground(oldColor);
                }
            });
            this.dialog.getContentPane().add(this.getChooser());
        }
        this.dialog.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
            this.chooser.addChooserPanel((AbstractColorChooserPanel)new EyeDropperColorChooserPanel());
        }
        return this.chooser;
    }

    public void setChooser(JColorChooser chooser) {
        JColorChooser oldChooser = this.getChooser();
        this.chooser = chooser;
        this.firePropertyChange("chooser", oldChooser, chooser);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.colorwell == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.colorwell.getWidth(), this.colorwell.getHeight());
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StreamflowJXColorSelectionButton.this.showDialog();
        }
    }

    private class ColorChangeListener
    implements ChangeListener {
        public StreamflowJXColorSelectionButton button;

        public ColorChangeListener(StreamflowJXColorSelectionButton button) {
            this.button = button;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

